/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.inventory.container.TreatBagContainer;
import doggytalents.common.util.NetworkUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DoggyContainerTypes {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"doggytalents");
    public static final Supplier<MenuType<FoodBowlContainer>> FOOD_BOWL = DoggyContainerTypes.register("food_bowl", (windowId, inv, data) -> {
        BlockPos pos = data.readBlockPos();
        return new FoodBowlContainer(windowId, inv.player.level(), pos, inv, inv.player);
    });
    public static final Supplier<MenuType<PackPuppyContainer>> PACK_PUPPY = DoggyContainerTypes.register("pack_puppy", (windowId, inv, data) -> {
        Entity entity = inv.player.level().getEntity(data.readInt());
        return entity instanceof Dog ? new PackPuppyContainer(windowId, inv, (Dog)entity) : null;
    });
    public static final Supplier<MenuType<TreatBagContainer>> TREAT_BAG = DoggyContainerTypes.register("treat_bag", (windowId, inv, data) -> {
        byte slotId = data.readByte();
        return new TreatBagContainer(windowId, inv, slotId, NetworkUtil.readItemFromBuf((FriendlyByteBuf)data));
    });
    public static final Supplier<MenuType<DogInventoriesContainer>> DOG_INVENTORIES = DoggyContainerTypes.register("dog_inventories", (windowId, inv, data) -> {
        int noDogs = data.readInt();
        ArrayList<Dog> dogs = new ArrayList<Dog>(noDogs);
        for (int i = 0; i < noDogs; ++i) {
            Entity entity = inv.player.level().getEntity(data.readInt());
            if (!(entity instanceof Dog)) continue;
            dogs.add((Dog)entity);
        }
        return !dogs.isEmpty() ? new DogInventoriesContainer(windowId, inv, dogs) : null;
    });
    public static final Supplier<MenuType<DogArmorContainer>> DOG_ARMOR = DoggyContainerTypes.register("dog_armor", (windowId, inv, data) -> {
        int dogId = data.readInt();
        Entity e = inv.player.level().getEntity(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DogArmorContainer(windowId, inv, (Dog)e);
    });
    public static final Supplier<MenuType<DoggyToolsMenu>> DOG_TOOLS = DoggyContainerTypes.register("dog_tools", (windowId, inv, data) -> {
        int dogId = data.readInt();
        Entity e = inv.player.level().getEntity(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DoggyToolsMenu(windowId, inv, (Dog)e);
    });
    public static final Supplier<MenuType<RiceMillMenu>> RICE_MILL = DoggyContainerTypes.register("rice_mill", (windowId, inv, data) -> {
        BlockPos pos = data.readBlockPos();
        return new RiceMillMenu(windowId, inv, pos);
    });

    private static <X extends AbstractContainerMenu, T extends MenuType<X>> Supplier<MenuType<X>> register(String name, IContainerFactory<X> factory) {
        return DoggyContainerTypes.register(name, () -> IMenuTypeExtension.create((IContainerFactory)factory));
    }

    private static <T extends MenuType<?>> Supplier<T> register(String name, Supplier<T> sup) {
        return CONTAINERS.register(name, sup);
    }
}

