/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.util.Optional;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AngelHaloModel
extends AnimatedSyncedAccessoryModel {
    public ModelPart halo;
    private Vector3f vecObj = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final AnimationDefinition HALO_SPINNA = AnimationDefinition.Builder.withLength((float)2.0f).looping().addAnimation("halo", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();

    public AngelHaloModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.head = Optional.of(box.getChild("head"));
        this.realHead = Optional.of(((ModelPart)this.head.get()).getChild("real_head"));
        this.halo = ((ModelPart)this.realHead.get()).getChild("halo");
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.root.visible = !dogIn.isDefeated();
    }

    public void prepareMobModel(Dog dog) {
        this.root.visible = dog.isDoingFine();
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        long animLenMillis = (long)HALO_SPINNA.lengthInSeconds() * 1000L;
        double offset = (double)(entityIn.getId() % 6) * 10.0;
        double timeLine = (offset + (double)((entityIn.isDefeated() ? 0.25f : 1.0f) * ageInTicks)) % Util.millisToTickMayWithPartial(animLenMillis);
        long timeLineMillis = Util.tickMayWithPartialToMillis(timeLine);
        if (entityIn.getId() % 2 == 0) {
            timeLineMillis = animLenMillis - timeLineMillis;
        }
        DogKeyframeAnimations.animate(this, entityIn, HALO_SPINNA, timeLineMillis, 1.0f, this.vecObj);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = head.addOrReplaceChild("real_head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition halo = real_head.addOrReplaceChild("halo", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -13.5f, -10.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(4, 4).addBox(-3.0f, -13.5f, -10.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(3.0f, -13.5f, -10.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(4, 4).addBox(-3.0f, -13.5f, -6.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.75f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    @Override
    public void resetAllPose() {
        this.root.resetPose();
        this.halo.resetPose();
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        super.renderToBuffer(stack, p_103014_, 0xF000F0, p_103016_, color_overlay);
    }
}

