/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.backward_imitate.RenderUtil_1_21_9;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.NullDogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DogRenderer
extends MobRenderer<Dog, DogRenderState_21_3, DogModel> {
    private static final int TXTCLR_DIFFOWNER = 1464486474;
    private static final int TXTCLR_HEALTH_70_100 = 720707;
    private static final int TXTCLR_HEALTH_30_70 = 15727189;
    private static final int TXTCLR_HEALTH_0_30 = 0xFF3636;
    private static final int TXTCLR_HEALTH_BKG = 0x4A4A4A;
    private static final int TXCLR_SEPERATOR = -6184543;
    private DogModel defaultModel;
    private NullDogModel nullDogModel;
    private List<RenderLayer<DogRenderState_21_3, DogModel>> originalDogLayers = List.of();

    public DogRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
        for (LayerFactory<DogRenderState_21_3, DogModel> layer : CollarRenderManager.getLayers()) {
            this.addLayer(layer.createLayer((RenderLayerParent<DogRenderState_21_3, DogModel>)this, ctx));
        }
        this.originalDogLayers = new ArrayList<RenderLayer<DogRenderState_21_3, DogModel>>(this.layers);
        this.nullDogModel = new NullDogModel(ctx.bakeLayer(ClientSetup.DOG_NULL));
        this.model = this.nullDogModel;
    }

    public void submit(DogRenderState_21_3 dog_render_state, PoseStack matrixStackIn, SubmitNodeCollector node_collector_1_21_9, CameraRenderState camera_state_1_21_9) {
        Dog dog = dog_render_state.dog;
        float partialTicks = dog_render_state.partialTick;
        DogSkin skin = dog.getClientSkin();
        this.model = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        dog_render_state.defferedSetup_1_21_9 = () -> {
            ((DogModel)this.model).resetWetShade();
            if (dog.isDogSoaked() && !dog.dogVariant().preventWetShade()) {
                float f = dog.getShadingWhileWet(partialTicks);
                ((DogModel)this.model).setWetShade(f);
            }
        };
        super.submit((LivingEntityRenderState)dog_render_state, matrixStackIn, node_collector_1_21_9, camera_state_1_21_9);
        this.model = this.nullDogModel;
    }

    private Component getNameUnknown(Dog dogIn) {
        return Component.translatable((String)(dogIn.getOwnerUUID() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public ResourceLocation getTextureLocation(DogRenderState_21_3 render_state) {
        return DogTextureManager.INSTANCE.getTexture(render_state.dog);
    }

    protected void scaleDog(Dog dogIn, DogRenderState_21_3 state, float partialTickTime) {
        DogModel model;
        float size = dogIn.isBaby() ? 0.5f : dogIn.getDogSize().getScale();
        this.shadowRadius = size * 0.5f;
        DogSkin skin = dogIn.getClientSkin();
        if (skin.useCustomModel() && (model = skin.getCustomModel().getValue()).hasDefaultScale()) {
            float default_scale = model.getDefaultScale();
            state.scale *= default_scale;
            this.shadowRadius *= default_scale;
        }
    }

    protected boolean shouldShowName(Dog dog, double distance_to_camera_sqr) {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_DOG_NAME.get()).booleanValue() && !dog.isVehicle() && dog.hasCustomName()) {
            return true;
        }
        return super.shouldShowName((Mob)dog, distance_to_camera_sqr);
    }

    protected void submitNameTag(DogRenderState_21_3 render_state, PoseStack stack, SubmitNodeCollector node_collector_1_21_9, CameraRenderState camera_state_1_21_9) {
        boolean isDiffOwner;
        RenderUtil_1_21_9.RenderContext_1_21_9 render_context_1_21_9 = new RenderUtil_1_21_9.RenderContext_1_21_9(node_collector_1_21_9, camera_state_1_21_9, render_state);
        Component text = render_state.dog.getCustomName();
        if (text == null) {
            return;
        }
        Dog dog = render_state.dog;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)dog);
        LocalPlayer player = Minecraft.getInstance().player;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.entityRenderDispatcher.crosshairPickEntity;
        boolean bl = isDiffOwner = player == null || !Objects.equals(player.getUUID(), dog.getOwnerUUID());
        if (isDiffOwner && ((Boolean)ConfigHandler.CLIENT.DONT_RENDER_DIFFOWNER_NAME.get()).booleanValue()) {
            return;
        }
        if (ClientHooks.isNameplateInRenderDistance((LivingEntity)dog, (double)d0)) {
            this.renderMainName(dog, text, stack, render_context_1_21_9, renderDiffOwnerName && isDiffOwner, isDiffOwner, !isDiffOwner && WhistleItem.isHoldingDutyWhistle((LivingEntity)player));
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, render_context_1_21_9, d0, renderDiffOwnerName && isDiffOwner, isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, Component text, PoseStack stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, boolean diffOwnerRender, boolean isDiffOwner, boolean renderDogOnDuty) {
        text = this.modifyMainText(dog, text, diffOwnerRender, renderDogOnDuty);
        this.renderDogText(dog, text, 0.0, 0.025f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private int getBkgTextColorWithOpacity(boolean diffOwnerRender) {
        boolean color = false;
        float bkg_opacity = 0.0f;
        if (!diffOwnerRender) {
            bkg_opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        }
        int alpha = (int)(bkg_opacity * 255.0f) << 24;
        return alpha | 0;
    }

    private void renderDogText(Dog dog, Component text, double y_offset_from_default, float scale, PoseStack stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, boolean render_diffowner, boolean is_diffowner) {
        boolean dog_not_sneaking = !dog.isDiscrete();
        double render_y_offset = (double)(dog.getBbHeight() + 0.5f) + y_offset_from_default;
        stack.pushPose();
        stack.translate(0.0, render_y_offset, 0.0);
        stack.mulPose((Quaternionfc)renderContext_1_21_9.cameraState().orientation);
        stack.scale(scale, -scale, scale);
        Matrix4f pose = stack.last().pose();
        Font font = this.getFont();
        float tX = -font.width((FormattedText)text) / 2;
        float tY = 0.0f;
        boolean bkg_see_through = dog_not_sneaking && !is_diffowner && (Boolean)ConfigHandler.CLIENT.SHOW_DOG_NAME_THRU_WALL.get() != false;
        Font.DisplayMode bkg_display_mode = bkg_see_through ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        int bkg_color = this.getBkgTextColorWithOpacity(render_diffowner);
        int bkg_txtcolor = 0x20FFFFFF;
        RenderUtil_1_21_9.submitNameTagRaw(renderContext_1_21_9, text, tX, tY, bkg_txtcolor, pose, bkg_display_mode, bkg_color);
        stack.translate(0.0, 0.0, 0.1);
        boolean draw_fg_text = dog_not_sneaking;
        if (draw_fg_text) {
            Font.DisplayMode fg_display_mode = Font.DisplayMode.NORMAL;
            int fg_color = 0;
            int fg_txtcolor = -1;
            RenderUtil_1_21_9.submitNameTagRaw(renderContext_1_21_9, text, tX, tY, fg_txtcolor, pose, fg_display_mode, fg_color);
        }
        stack.popPose();
    }

    private void renderExtraInfo(Dog dog, Component text, PoseStack stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        this.renderInfoDogText(dog, text, stack, renderContext_1_21_9, d0, diffOwnerRender, isDiffOwner);
        this.renderSecondaryInfoDogText(dog, text, stack, renderContext_1_21_9, d0, diffOwnerRender, isDiffOwner);
    }

    private void renderInfoDogText(Dog dog, Component text, PoseStack stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        boolean renderHealthInNameActivated = this.entityRenderDispatcher.camera.getEntity().isShiftKeyDown() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        String seperator = (String)ConfigHandler.CLIENT.DOG_INFO_SEPERATOR.get();
        MutableComponent seperator_c1 = this.createC1WithColor(seperator, -6184543);
        MutableComponent extra_info_c1 = Component.translatable((String)dog.getMode().getTip());
        Optional<Component> hunger_c1_optional = this.getHungerC1(dog, renderHealthInNameActivated);
        Optional<Component> gender_c1_optional = this.getGenderC1(dog);
        if (hunger_c1_optional.isPresent()) {
            extra_info_c1.append((Component)seperator_c1);
            Component hunger_c1 = hunger_c1_optional.get();
            extra_info_c1.append(hunger_c1);
        }
        if (gender_c1_optional.isPresent()) {
            extra_info_c1.append((Component)seperator_c1);
            Component gender_c1 = gender_c1_optional.get();
            extra_info_c1.append(gender_c1);
        }
        if (diffOwnerRender) {
            extra_info_c1 = this.createC1WithColor((Component)extra_info_c1, 1464486474);
        }
        this.renderDogText(dog, (Component)extra_info_c1, 0.12f, 0.01f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private void renderSecondaryInfoDogText(Dog dog, Component text, PoseStack stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        if (d0 > 25.0) {
            return;
        }
        Entity camera_entity = this.entityRenderDispatcher.camera.getEntity();
        if (!camera_entity.isShiftKeyDown()) {
            return;
        }
        if (dog.getOwner() == camera_entity) {
            return;
        }
        Component ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
        if (diffOwnerRender) {
            ownerC0 = this.createC1WithColor(ownerC0, 1464486474);
        }
        this.renderDogText(dog, ownerC0, -0.25, 0.01f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private Optional<Component> getHungerC1(Dog dog, boolean renderHealthInNameActivated) {
        boolean hightlight_red;
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && !dog.isDefeated()) {
            return Optional.empty();
        }
        String hunger_format = (String)ConfigHandler.CLIENT.DOG_INFO_HUNGER_FORMAT.get();
        int hunger = 0;
        hunger = dog.isDefeated() ? -dog.getDogIncapValue() : Mth.ceil((float)dog.getDogHunger());
        MutableComponent hunger_c1 = Component.literal((String)String.format(Locale.ROOT, hunger_format, hunger));
        boolean bl = hightlight_red = dog.getDogHunger() <= 10.0f && renderHealthInNameActivated || dog.isDefeated();
        if (hightlight_red) {
            hunger_c1.withStyle(Style.EMPTY.withColor(0xFF3636));
        }
        return Optional.of(hunger_c1);
    }

    private Optional<Component> getGenderC1(Dog dog) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue()) {
            return Optional.empty();
        }
        MutableComponent ret = Component.translatable((String)dog.getGender().getUnlocalisedTip());
        return Optional.of(ret);
    }

    private Component modifyMainText(Dog dog, Component text, boolean diffOwnerRender, boolean renderDogOnDuty) {
        boolean renderHealthInNameActive;
        if (diffOwnerRender) {
            text = this.createC1WithColor(text, 1464486474);
            return text;
        }
        if (renderDogOnDuty) {
            if (dog.dogOnDuty()) {
                text = this.createC1WithColor(text, -61191);
            }
            return text;
        }
        if (ClientEventHandler.shouldRenderAnimDebugNametag(dog)) {
            text = this.createC1WithColor(text, -3299584);
            return text;
        }
        boolean bl = renderHealthInNameActive = this.entityRenderDispatcher.camera.getEntity().isShiftKeyDown() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (renderHealthInNameActive) {
            text = this.colorTextWithHealth(dog, text);
        }
        return text;
    }

    private Component colorTextWithHealth(Dog dog, Component text) {
        int noCharsInName = text.getString().length();
        float healthPercentage = dog.getHealth() / dog.getMaxHealth();
        healthPercentage = Mth.clamp((float)healthPercentage, (float)0.0f, (float)1.0f);
        int noCharHighlighted = Mth.ceil((float)((float)noCharsInName * healthPercentage));
        noCharHighlighted = Mth.clamp((int)noCharHighlighted, (int)0, (int)noCharsInName);
        String hlPart = text.getString().substring(0, noCharHighlighted);
        String nonHlPart = "";
        if (noCharHighlighted <= noCharsInName) {
            nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
        }
        int color = 0xFF3636;
        if ((double)healthPercentage >= 0.7) {
            color = 720707;
        } else if ((double)healthPercentage >= 0.3) {
            color = 15727189;
        }
        MutableComponent newTxt = this.createC1WithColor(hlPart, color);
        MutableComponent restTxt = this.createC1WithColor(nonHlPart, 0x4A4A4A);
        newTxt.append((Component)restTxt);
        text = newTxt;
        return text;
    }

    private MutableComponent createC1WithColor(String str, int color) {
        return Component.literal((String)str).withStyle(Style.EMPTY.withColor(color));
    }

    private MutableComponent createC1WithColor(Component c1, int color) {
        return this.createC1WithColor(c1.getString(), color);
    }

    public DogRenderState_21_3 createRenderState() {
        return new DogRenderState_21_3();
    }

    public void extractRenderState(Dog dog, DogRenderState_21_3 extract_to, float p_ticks) {
        super.extractRenderState((LivingEntity)dog, (LivingEntityRenderState)extract_to, p_ticks);
        extract_to.dog = dog;
        this.scaleDog(dog, extract_to, p_ticks);
        this.extractRightHandItemModelForDog(dog, extract_to);
    }

    private void extractRightHandItemModelForDog(Dog dog, DogRenderState_21_3 extract_to) {
    }

    protected float getShadowRadius(DogRenderState_21_3 p_365066_) {
        return this.shadowRadius;
    }

    public static int getOverlayCoords(Dog dog, float p_115340_) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)p_115340_), (int)OverlayTexture.v((dog.hurtTime > 0 || dog.deathTime > 0 ? 1 : 0) != 0));
    }
}

