/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;

public class DoggyArmorMapping {
    private static final Map<Item, ResourceLocation> LEGACY_MAPPING = new ImmutableMap.Builder().put((Object)Items.IRON_HELMET, (Object)Resources.IRON_HELMET).put((Object)Items.DIAMOND_HELMET, (Object)Resources.DIAMOND_HELMET).put((Object)Items.GOLDEN_HELMET, (Object)Resources.GOLDEN_HELMET).put((Object)Items.CHAINMAIL_HELMET, (Object)Resources.CHAINMAIL_HELMET).put((Object)Items.TURTLE_HELMET, (Object)Resources.TURTLE_HELMET).put((Object)Items.NETHERITE_HELMET, (Object)Resources.NETHERITE_HELMET).put((Object)Items.IRON_BOOTS, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.DIAMOND_BOOTS, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.GOLDEN_BOOTS, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.CHAINMAIL_BOOTS, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.NETHERITE_BOOTS, (Object)Resources.NETHERITE_BODY_PIECE).put((Object)Items.IRON_CHESTPLATE, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.DIAMOND_CHESTPLATE, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.GOLDEN_CHESTPLATE, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.CHAINMAIL_CHESTPLATE, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.NETHERITE_CHESTPLATE, (Object)Resources.NETHERITE_BODY_PIECE).put((Object)Items.LEATHER_HELMET, (Object)Resources.LEATHER_HELMET).put((Object)Items.LEATHER_BOOTS, (Object)Resources.LEATHER_BOOTS).put((Object)Items.LEATHER_CHESTPLATE, (Object)Resources.LEATHER_BODY_PIECE).put((Object)Items.LEATHER_LEGGINGS, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.IRON_LEGGINGS, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.DIAMOND_LEGGINGS, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.GOLDEN_LEGGINGS, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.CHAINMAIL_LEGGINGS, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.NETHERITE_LEGGINGS, (Object)Resources.NETHERITE_BODY_PIECE).build();
    private static Map<Item, ResourceLocation> MAPPING = Maps.newConcurrentMap();

    private static ResourceLocation computeArmorTexture(Item item, Dog dog, ItemStack stack) {
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return Resources.DEFAULT_DOG_ARMOR;
        }
        List<EquipmentClientInfo.Layer> armor_layers_21_3 = DoggyArmorMapping.getEquippimentLayer_21_3(stack);
        if (armor_layers_21_3.isEmpty()) {
            return Resources.DEFAULT_DOG_ARMOR;
        }
        ResourceLocation armorLoc = armor_layers_21_3.get(0).getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID);
        if (!ClientEventHandler.vertifyArmorTexture(armorLoc)) {
            return Resources.DEFAULT_DOG_ARMOR;
        }
        return armorLoc;
    }

    public static ResourceLocation getMappedResource(Item item, Dog dog, ItemStack stack) {
        if (((Boolean)ConfigHandler.CLIENT.USE_LEGACY_DOG_ARMOR_RENDER.get()).booleanValue()) {
            return DoggyArmorMapping.getLegacyMappedResource(dog, item);
        }
        return MAPPING.computeIfAbsent(item, x -> DoggyArmorMapping.computeArmorTexture(x, dog, stack));
    }

    public static ResourceLocation getLegacyMappedResource(Dog dog, Item item) {
        ResourceLocation x = LEGACY_MAPPING.get(item);
        if (x != null) {
            return x;
        }
        EquipmentSlot slot = dog.getEquipmentSlotForItem(new ItemStack((ItemLike)item));
        switch (slot) {
            case CHEST: {
                return Resources.IRON_BODY_PIECE;
            }
            case FEET: {
                return Resources.IRON_BOOTS;
            }
            case HEAD: {
                return Resources.IRON_HELMET;
            }
            case LEGS: {
                return Resources.IRON_BODY_PIECE;
            }
        }
        return Resources.IRON_BODY_PIECE;
    }

    private static List<EquipmentClientInfo.Layer> getEquippimentLayer_21_3(ItemStack stack) {
        Equippable equip = ItemUtil.getEquippable_1_21_3(stack);
        if (equip == null) {
            return List.of();
        }
        Optional model_optional = equip.assetId();
        if (!model_optional.isPresent()) {
            return List.of();
        }
        ResourceKey model_loc = (ResourceKey)model_optional.get();
        Minecraft mc = Minecraft.getInstance();
        EquipmentClientInfo model = mc.getEntityRenderDispatcher().equipmentAssets.get(model_loc);
        if (model == null) {
            return List.of();
        }
        List model_layers = model.getLayers(EquipmentClientInfo.LayerType.HUMANOID);
        if (model_layers == null) {
            return List.of();
        }
        return model_layers;
    }
}

