/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import doggytalents.client.backward_imitate.GuiUtil_1_21_9;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class FlatButton
extends GuiUtil_1_21_9.AbstractButton_1_21_9 {
    public static final int DEFAULT_COLOR = 0x5E5D5D;
    public static final int NON_HL_COLOR_MASK = 0x48000000;
    public static final int HL_COLOR_MASK = -2097152000;
    Font font;
    protected final OnPress onPress;
    protected boolean visibleWhenNotActive = false;
    protected int buttonColor = 0x5E5D5D;

    public FlatButton(int x, int y, int width, int height, Component msg, OnPress onPress) {
        super(x, y, width, height, msg);
        this.font = Minecraft.getInstance().font;
        this.onPress = onPress;
    }

    @Override
    public void onPress() {
        this.onPress.onPress(this);
    }

    public FlatButton visibleWhenNotActive() {
        this.visibleWhenNotActive = true;
        return this;
    }

    public FlatButton withButtonColor(int color) {
        this.buttonColor = color;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.active && !this.visibleWhenNotActive) {
            return;
        }
        int cl = this.maskColor(this.buttonColor, this.isHovered && this.active);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, cl);
        int mX = this.getX() + this.width / 2;
        int mY = this.getY() + this.height / 2;
        Component msg = this.getMessage();
        int tX = mX - this.font.width((FormattedText)msg) / 2;
        Objects.requireNonNull(this.font);
        int tY = mY - 9 / 2;
        msg = this.modifyMessage(msg);
        graphics.drawString(this.font, msg, tX, tY, -1);
    }

    protected int maskColor(int color, boolean hightlight) {
        return color | (hightlight ? -2097152000 : 0x48000000);
    }

    public Component modifyMessage(Component msg) {
        if (!this.active) {
            msg = msg.copy().withStyle(Style.EMPTY.withColor(-8224126));
        }
        return msg;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static interface OnPress {
        public void onPress(FlatButton var1);
    }
}

