/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.mojang.serialization.MapCodec;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.common.Screens;
import doggytalents.common.backward_imitate.ResourceKeyHelper_21_3;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.util.InventoryUtil;
import doggytalents.common.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FoodBowlBlock
extends BaseEntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final MapCodec<FoodBowlBlock> CODEC = FoodBowlBlock.simpleCodec(FoodBowlBlock::new);

    public FoodBowlBlock() {
        super(BlockBehaviour.Properties.of().setId(ResourceKeyHelper_21_3.blockKey("food_bowl")).mapColor(MapColor.METAL).strength(1.0f, 5.0f).sound(SoundType.METAL));
    }

    public FoodBowlBlock(BlockBehaviour.Properties props) {
        this();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new FoodBowlTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return FoodBowlBlock.createTickerHelper(blockEntityType, DoggyTileEntityTypes.FOOD_BOWL.get(), FoodBowlTileEntity::tick);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        FoodBowlTileEntity foodBowlTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class);
        if (foodBowlTileEntity != null) {
            foodBowlTileEntity.setPlacer(placer);
        }
        worldIn.setBlock(pos, state, 2);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, InsideBlockEffectApplier p_405359_) {
        FoodBowlTileEntity foodBowl;
        if (entityIn instanceof ItemEntity && (foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class)) != null) {
            ItemEntity entityItem = (ItemEntity)entityIn;
            ItemStackHandler bowlInventory = foodBowl.getInventory();
            ItemStack remaining = InventoryUtil.addItem((IItemHandler)bowlInventory, entityItem.getItem());
            if (!remaining.isEmpty()) {
                entityItem.setItem(remaining);
            } else {
                entityItem.discard();
                worldIn.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.25f, ((worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state, Level worldIn) {
        FoodBowlTileEntity foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class);
        if (foodBowl != null) {
            ItemStackHandler bowlInventory = foodBowl.getInventory();
            for (int i = 0; i < bowlInventory.getSlots(); ++i) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)bowlInventory.getStackInSlot(i));
            }
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState blockStateIn, Level worldIn, BlockPos posIn, Player playerIn, BlockHitResult result) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        FoodBowlTileEntity foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, posIn, FoodBowlTileEntity.class);
        if (foodBowl != null && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Screens.openFoodBowlScreen(serverPlayer, foodBowl);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(worldIn));
        }
        return facing == Direction.DOWN && !stateIn.canSurvive(worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, worldIn, tickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState FluidState2 = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

