/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.util.DogFoodUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FoodBowlTileEntity
extends PlacedTileEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FoodBowlTileEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FoodHandler.isFood(stack).isPresent();
        }
    };
    public int timeoutCounter;

    public FoodBowlTileEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.FOOD_BOWL.get(), pos, blockState);
    }

    @Override
    public void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.inventory.deserialize(compound);
    }

    @Override
    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        this.inventory.serialize(compound);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (!(blockEntity instanceof FoodBowlTileEntity)) {
            return;
        }
        FoodBowlTileEntity bowl = (FoodBowlTileEntity)blockEntity;
        if (++bowl.timeoutCounter < 20) {
            return;
        }
        List dogList = level.getEntitiesOfClass(Dog.class, new AABB(pos).inflate(5.0, 5.0, 5.0));
        for (Dog dog : dogList) {
            if (!dog.isDoingFine()) continue;
            UUID placerId = bowl.getPlacerId();
            if (placerId != null && !dog.getBowlPos().isPresent() && placerId.equals(dog.getOwnerUUID())) {
                dog.setBowlPos(bowl.getBlockPos());
            }
            if (!bowl.shouldFeed(dog)) continue;
            dog.triggerAction(new DogEatFromFoodBowl(dog, bowl));
        }
        bowl.timeoutCounter = 0;
    }

    private boolean shouldFeed(Dog target) {
        if (!target.readyForNonTrivialAction()) {
            return false;
        }
        if (target.isInSittingPose()) {
            return false;
        }
        if (target.isOrderedToSit()) {
            return false;
        }
        if (!this.hasFood(target)) {
            return false;
        }
        return this.isHungryDog(target);
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    public boolean hasFood(Dog dog) {
        return DogFoodUtil.dogFindFoodInInv(dog, false, this.getInventory()) >= 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.doggytalents.food_bowl");
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerIn) {
        return new FoodBowlContainer(windowId, this.level, this.worldPosition, playerInventory, playerIn);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState old_state) {
        if (this.level != null) {
            DoggyBlocks.FOOD_BOWL.get().preRemoveSideEffects(pos, old_state, this.level);
        }
    }

    public static class DogEatFromFoodBowl
    extends TriggerableAction {
        private final FoodBowlTileEntity bowl;
        private int tickTillPathRecalc;
        private boolean enoughHealingFood = false;
        private int goToBowlTimeout = 0;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromFoodBowl(Dog dog, FoodBowlTileEntity bowl) {
            super(dog, false, false);
            this.bowl = bowl;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
        }

        @Override
        public void tick() {
            boolean is_close_to_bowl;
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = is_close_to_bowl = this.getBowlDistanceSqr() <= 2.25;
            if (!is_close_to_bowl) {
                --this.goToBowlTimeout;
            }
            if (this.goToBowlTimeout <= 0 && !is_close_to_bowl) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (!is_close_to_bowl) {
                Vec3 bowlPos = this.getBowPos();
                this.dog.getLookControl().setLookAt(bowlPos.x, bowlPos.y, bowlPos.z, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                        this.dog.getNavigation().moveTo(bowlPos.x, bowlPos.y, bowlPos.z, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.getNavigation().stop();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.hasEffect(MobEffects.REGENERATION);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, true, this.bowl.getInventory());
            } else {
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, false, this.bowl.getInventory());
            }
            this.feedCooldown = this.dog.getRandom().nextInt(11);
        }

        private boolean stillValidTarget() {
            if (this.bowl.isRemoved()) {
                return false;
            }
            if (this.getBowlDistanceSqr() > 256.0) {
                return false;
            }
            return this.bowl.hasFood(this.dog);
        }

        private double getBowlDistanceSqr() {
            Vec3 bowlPos = this.getBowPos();
            return this.dog.distanceToSqr(bowlPos);
        }

        private Vec3 getBowPos() {
            return Vec3.atBottomCenterOf((Vec3i)this.bowl.getBlockPos());
        }
    }
}

