/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class DogGroupsManager {
    public static final int MAX_GROUP_STRLEN = 16;
    public static final int MAX_GROUP_SIZE = 3;
    private List<DogGroup> groups = new ArrayList<DogGroup>(3);

    public List<DogGroup> getGroupsReadOnly() {
        return Collections.unmodifiableList(this.groups);
    }

    public void load(CompoundTag_1_21_5 compound) {
        ListTag_1_21_5 groupsListTag = compound.getList("doggy_groups", 10);
        for (Tag tag : groupsListTag) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag groupTag = (CompoundTag)tag;
            String group_name = CompoundTag_1_21_5.wrap(groupTag).getString("group_name");
            int group_color = CompoundTag_1_21_5.wrap(groupTag).getInt("group_color");
            this.add(new DogGroup(group_name, group_color));
        }
    }

    public void save(CompoundTag compound) {
        ListTag groupsListTag = new ListTag();
        for (DogGroup group : this.getGroupsReadOnly()) {
            CompoundTag groupTag = new CompoundTag();
            groupTag.putString("group_name", group.name);
            groupTag.putInt("group_color", group.color);
            groupsListTag.add((Object)groupTag);
        }
        compound.put("doggy_groups", (Tag)groupsListTag);
    }

    public boolean isGroup(DogGroup group) {
        return this.getGroupsReadOnly().contains(group);
    }

    public boolean add(DogGroup group) {
        if (this.groups.size() >= 3) {
            return false;
        }
        if (this.groups.contains(group)) {
            return false;
        }
        if (group.name.length() > 16) {
            return false;
        }
        if (group.name.isEmpty()) {
            return false;
        }
        this.groups.add(group);
        return true;
    }

    public boolean remove(DogGroup group) {
        if (!this.groups.contains(group)) {
            return false;
        }
        this.groups.remove(group);
        return true;
    }

    public void clear() {
        this.groups.clear();
    }

    public static class DogGroup {
        public final int color;
        public final String name;

        public DogGroup(String name, int color) {
            this.color = color;
            this.name = name == null ? "" : (name.length() > 16 ? name.substring(0, 16) : name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DogGroup)) {
                return false;
            }
            DogGroup group = (DogGroup)obj;
            return group.color == this.color && group.name.equals(this.name);
        }
    }
}

