/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.DogAllowSleepOnGoal;
import doggytalents.common.entity.ai.DogAvoidPushWhenIdleGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogBeingPetGoal;
import doggytalents.common.entity.ai.DogBreedGoal;
import doggytalents.common.entity.ai.DogCommonSitIdleGoal;
import doggytalents.common.entity.ai.DogCommonStandIdleGoal;
import doggytalents.common.entity.ai.DogDrunkGoal;
import doggytalents.common.entity.ai.DogFeelingNakeyGoal;
import doggytalents.common.entity.ai.DogFindWaterGoal;
import doggytalents.common.entity.ai.DogFloatGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoalDefeated;
import doggytalents.common.entity.ai.DogGoAwayFromFireGoal;
import doggytalents.common.entity.ai.DogGoBackToSitAfterFinishAction;
import doggytalents.common.entity.ai.DogGoRestOnBedGoalDefeated;
import doggytalents.common.entity.ai.DogHungryGoal;
import doggytalents.common.entity.ai.DogHurtByTargetGoal;
import doggytalents.common.entity.ai.DogLookAtPlayerGoal;
import doggytalents.common.entity.ai.DogLowHealthGoal;
import doggytalents.common.entity.ai.DogMeleeAttackGoal;
import doggytalents.common.entity.ai.DogMoveBackToRestrictGoal;
import doggytalents.common.entity.ai.DogNearestToOwnerAttackableTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtTargetGoal;
import doggytalents.common.entity.ai.DogProtestSitOrderGoal;
import doggytalents.common.entity.ai.DogRandomSitIdleGoal;
import doggytalents.common.entity.ai.DogRandomSniffGoal;
import doggytalents.common.entity.ai.DogRandomStandIdleGoal;
import doggytalents.common.entity.ai.DogRandomStrollGoal;
import doggytalents.common.entity.ai.DogRangedAttackGoal;
import doggytalents.common.entity.ai.DogRestWhenSitGoal;
import doggytalents.common.entity.ai.DogSitWhenOrderedGoal;
import doggytalents.common.entity.ai.DogTacticalTargetGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.PatrolAssistTargetGoal;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

public class DogAiManager {
    private static final String PROFILER_STR = "dogAi";
    private final Dog dog;
    private final Supplier<ProfilerFiller> profilerSup;
    private final ArrayList<WrappedGoal> goals = new ArrayList();
    private final ArrayList<WrappedGoal> targetGoals = new ArrayList();
    private final ArrayList<IHasTickNonRunning> tickNonRunningGoals = new ArrayList();
    private final Map<Goal.Flag, WrappedGoal> runningGoalsWithFlag = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final EnumSet<Goal.Flag> lockedFlags = EnumSet.noneOf(Goal.Flag.class);
    private DogSitWhenOrderedGoal sitGoal;
    private DogBeingPetGoal beingPetGoal;
    private DogFollowOwnerGoal followOwnerGoal;
    private WrappedGoal sitGoalWrapped;
    private DogActionExecutorGoal nonTrivialActionGoal;
    private DogActionExecutorGoal trivialActionGoal;
    private int delayedActionStart = 0;
    private int timeoutPending = 0;
    private boolean startedSomeGoals = false;

    public DogAiManager(Dog dog, Supplier<ProfilerFiller> profileSup) {
        this.dog = dog;
        this.profilerSup = profileSup;
    }

    public void init() {
        int p = 1;
        this.registerDogGoal(p, (Goal)new DogFloatGoal(this.dog));
        this.registerDogGoal(p, new DogDrunkGoal(this.dog));
        this.registerDogGoal(p, new DogAvoidPushWhenIdleGoal(this.dog));
        this.registerDogGoal(++p, new DogGoAwayFromFireGoal(this.dog));
        this.initSitGoal(++p);
        this.registerDogGoal(p, new DogProtestSitOrderGoal(this.dog));
        this.registerDogGoal(++p, new DogLowHealthGoal.StickToOwner(this.dog));
        this.registerDogGoal(p, new DogLowHealthGoal.RunAway(this.dog));
        this.registerDogGoal(p, new DogAllowSleepOnGoal(this.dog));
        this.initTriggerableActionGoals(false, ++p);
        this.registerDogGoal(++p, new DogHungryGoal(this.dog, 1.0, 2.0f));
        this.registerDogGoal(++p, new GuardModeGoal.Minor(this.dog));
        this.registerDogGoal(p, new GuardModeGoal.Major(this.dog));
        this.registerDogGoal(++p, new DogRangedAttackGoal(this.dog));
        this.registerDogGoal(p, new DogMeleeAttackGoal(this.dog));
        this.registerDogGoal(p, new DogGoRestOnBedGoalDefeated(this.dog));
        this.registerDogGoal(++p, new DogFindWaterGoal(this.dog));
        this.initTriggerableActionGoals(true, ++p);
        this.registerDogGoal(p, new DogFollowOwnerGoalDefeated(this.dog));
        this.initFollowOwnerGoal(p);
        this.registerDogGoal(++p, new DogGoBackToSitAfterFinishAction(this.dog));
        this.registerDogGoal(p, (Goal)new DogMoveBackToRestrictGoal(this.dog));
        this.registerDogGoal(p, new DogBreedGoal(this.dog, 1.0));
        this.registerDogGoal(++p, (Goal)new DogRandomStrollGoal(this.dog, 1.0));
        this.registerDogGoal(p, new DogRandomStandIdleGoal(this.dog));
        this.registerDogGoal(p, new DogRandomSniffGoal(this.dog));
        this.registerDogGoal(p, new DogCommonStandIdleGoal(this.dog));
        this.initBeingPetGoal(p);
        this.registerDogGoal(++p, new DogBegGoal(this.dog, 8.0f));
        this.registerDogGoal(++p, new DogFeelingNakeyGoal(this.dog));
        this.registerDogGoal(p, (Goal)new DogLookAtPlayerGoal(this.dog));
        this.registerDogGoal(p, (Goal)new RandomLookAroundGoal((Mob)this.dog));
        this.registerDogGoal(p, new DogRandomSitIdleGoal(this.dog));
        this.registerDogGoal(p, new DogCommonSitIdleGoal(this.dog));
        this.registerDogGoal(p, new DogRestWhenSitGoal(this.dog));
        this.registerTargetGoal(1, new DogTacticalTargetGoal(this.dog));
        this.registerTargetGoal(1, (TargetGoal)new DogOwnerHurtByTargetGoal(this.dog));
        this.registerTargetGoal(2, (TargetGoal)new DogOwnerHurtTargetGoal(this.dog));
        this.registerTargetGoal(3, (TargetGoal)new DogHurtByTargetGoal(this.dog));
        this.registerTargetGoal(6, (TargetGoal)new BerserkerModeGoal(this.dog));
        this.registerTargetGoal(6, (TargetGoal)new GuardModeGoal(this.dog));
        this.registerTargetGoal(6, (TargetGoal)new PatrolAssistTargetGoal(this.dog));
        this.registerTargetGoal(7, (TargetGoal)new DogNearestToOwnerAttackableTargetGoal<AbstractSkeleton>(this.dog, AbstractSkeleton.class, false));
    }

    private void initTriggerableActionGoals(boolean trivial, int priority) {
        if (!trivial) {
            this.nonTrivialActionGoal = new DogActionExecutorGoal(this, trivial, priority);
            this.registerDogGoal(priority, this.nonTrivialActionGoal);
        } else {
            this.trivialActionGoal = new DogActionExecutorGoal(this, trivial, priority);
            this.registerDogGoal(priority, this.trivialActionGoal);
        }
    }

    private void initSitGoal(int priority) {
        this.sitGoal = new DogSitWhenOrderedGoal(this.dog);
        this.sitGoalWrapped = this.registerDogGoal(priority, this.sitGoal);
    }

    private void initBeingPetGoal(int priority) {
        this.beingPetGoal = new DogBeingPetGoal(this.dog);
        this.registerDogGoal(priority, this.beingPetGoal);
    }

    private void initFollowOwnerGoal(int priority) {
        this.followOwnerGoal = new DogFollowOwnerGoal(this.dog, 1.0, 10.0f, 2.0f);
        this.registerDogGoal(priority, this.followOwnerGoal);
    }

    private WrappedGoal registerDogGoal(int priority, Goal goal) {
        WrappedGoal ret = new WrappedGoal(priority, goal);
        if (goal instanceof IHasTickNonRunning) {
            IHasTickNonRunning ticker = (IHasTickNonRunning)goal;
            this.tickNonRunningGoals.add(ticker);
        }
        this.goals.add(ret);
        return ret;
    }

    private void registerTargetGoal(int priority, TargetGoal goal) {
        this.targetGoals.add(new WrappedGoal(priority, (Goal)goal));
    }

    public void tickServer() {
        if (!this.dog.canUpdateDogAi()) {
            if (this.getActiveAction().isPresent()) {
                this.clearTriggerableAction();
            }
            if (this.startedSomeGoals) {
                this.startedSomeGoals = false;
                this.forceStopAllGoal();
            }
            return;
        }
        ProfilerFiller profiler = this.profilerSup.get();
        profiler.push(PROFILER_STR);
        if (this.delayedActionStart > 0) {
            --this.delayedActionStart;
        } else {
            this.timeoutPending();
        }
        this.tickNonRunningGoalWithPrev();
        boolean updateTime = this.isTimeToUpdateNonEveryTick(this.dog);
        this.invalidateRunning(updateTime);
        this.invalidateFlags(updateTime);
        this.startNewGoalOrAction(updateTime);
        this.tickRunning(updateTime);
        profiler.pop();
    }

    private void timeoutPending() {
        Optional<TriggerableAction> activeActionOptional = this.getActiveAction();
        if (!activeActionOptional.isPresent()) {
            return;
        }
        if (activeActionOptional.get().getState() != TriggerableAction.ActionState.PENDING) {
            return;
        }
        ++this.timeoutPending;
        if (this.timeoutPending >= 20) {
            this.clearTriggerableAction();
        }
    }

    private void invalidateRunning(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.stopRunningGoalIfShouldBeStopped(this.goals);
            this.stopRunningGoalIfShouldBeStopped(this.targetGoals);
        }
    }

    private void invalidateFlags(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.invalidateNotRunningFlags();
        }
    }

    private void startNewGoalOrAction(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.findNewGoalToStart(this.goals);
            this.findNewGoalToStart(this.targetGoals);
        }
    }

    private void tickRunning(boolean goalUpdateTime) {
        boolean only_tick_always_update = !goalUpdateTime;
        this.tickRunningGoals(this.goals, only_tick_always_update);
        this.tickRunningGoals(this.targetGoals, only_tick_always_update);
    }

    private void tickNonRunningGoalWithPrev() {
        for (IHasTickNonRunning goal : this.tickNonRunningGoals) {
            goal.tickDogWhenNotRunning();
        }
    }

    private boolean isTimeToUpdateNonEveryTick(Dog dog) {
        if (dog.tickCount <= 1) {
            return false;
        }
        int timeLine = dog.level().getServer().getTickCount() + dog.getId();
        return timeLine % 2 == 0;
    }

    private void invalidateNotRunningFlags() {
        Iterator<Map.Entry<Goal.Flag, WrappedGoal>> itr = this.runningGoalsWithFlag.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Goal.Flag, WrappedGoal> entry = itr.next();
            WrappedGoal value = entry.getValue();
            if (value != null && value.isRunning()) continue;
            itr.remove();
        }
    }

    private void stopRunningGoalIfShouldBeStopped(ArrayList<WrappedGoal> goalList) {
        for (WrappedGoal goal : goalList) {
            if (!goal.isRunning() || !this.goalMustStop(goal)) continue;
            this.stopGoal(goal);
        }
    }

    private boolean goalMustStop(WrappedGoal goal) {
        if (this.goalHasLockedFlag(goal)) {
            return true;
        }
        return !goal.canContinueToUse();
    }

    private void findNewGoalToStart(ArrayList<WrappedGoal> goalList) {
        for (WrappedGoal goal : goalList) {
            if (goal.isRunning() || !this.goalCanStart(goal)) continue;
            this.startGoal(goal);
        }
    }

    private void startGoal(WrappedGoal goal) {
        if (goal.getGoal() == this.beingPetGoal) {
            this.beingPetGoal.dogBeingPetGoalPreStart();
        }
        for (Goal.Flag flag : goal.getFlags()) {
            WrappedGoal runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal != null) {
                this.stopGoal(runningGoal);
            }
            this.runningGoalsWithFlag.put(flag, goal);
        }
        goal.start();
        this.startedSomeGoals = true;
    }

    private boolean goalCanStart(WrappedGoal goal) {
        if (this.goalHasLockedFlag(goal)) {
            return false;
        }
        if (this.isBlockedByAnotherGoalSharingFlag(goal)) {
            return false;
        }
        return goal.canUse();
    }

    private boolean isBlockedByAnotherGoalSharingFlag(WrappedGoal goal) {
        EnumSet flags = goal.getFlags();
        if (flags.isEmpty()) {
            return false;
        }
        for (Goal.Flag flag : flags) {
            WrappedGoal runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.canBeReplacedBy(goal)) continue;
            return true;
        }
        return false;
    }

    private void tickRunningGoals(ArrayList<WrappedGoal> goalList, boolean tick_only_always_update) {
        for (WrappedGoal goal : goalList) {
            if (!goal.isRunning() || tick_only_always_update && !goal.requiresUpdateEveryTick()) continue;
            goal.tick();
        }
    }

    private boolean goalHasLockedFlag(WrappedGoal goal) {
        for (Goal.Flag flag : goal.getFlags()) {
            if (!this.lockedFlags.contains(flag)) continue;
            return true;
        }
        return false;
    }

    private void stopGoal(WrappedGoal goal) {
        goal.stop();
        if (goal.getFlags().contains(Goal.Flag.MOVE)) {
            this.dog.getNavigation().stop();
        }
    }

    public void setLockedFlag(Goal.Flag flag, boolean free) {
        if (!free) {
            this.lockedFlags.add(flag);
        } else {
            this.lockedFlags.remove(flag);
        }
    }

    public void forceStopAllGoal() {
        this.clearTriggerableAction();
        for (WrappedGoal goal : this.goals) {
            if (!goal.isRunning()) continue;
            this.stopGoal(goal);
        }
    }

    public void forceStopAllGoalWithFlag(Goal.Flag flag) {
        if (this.nonTrivialActionGoal.getFlags().contains(flag)) {
            this.clearTriggerableAction();
        }
        for (WrappedGoal goal : this.goals) {
            if (!goal.isRunning() || !goal.getFlags().contains(flag)) continue;
            this.stopGoal(goal);
        }
    }

    private void onNonTrivialActionInterupted() {
        this.trivialActionGoal.clearAction();
    }

    public boolean isBusy() {
        if (this.getActiveAction().isPresent()) {
            return true;
        }
        int trivial_p = this.trivialActionGoal.getPriority();
        for (Goal.Flag flag : this.trivialActionGoal.getFlags()) {
            if (this.lockedFlags.contains(flag)) {
                return true;
            }
            WrappedGoal runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.getGoal() == this.sitGoal || !runningGoal.isRunning() || runningGoal.getPriority() > trivial_p) continue;
            return true;
        }
        return false;
    }

    public boolean readyForNonTrivivalAction() {
        boolean hasNonTrivialAction = this.getActiveAction().map(x -> !x.isTrivial()).orElse(false);
        if (hasNonTrivialAction) {
            return false;
        }
        int non_trivial_p = this.nonTrivialActionGoal.getPriority();
        for (Goal.Flag flag : this.nonTrivialActionGoal.getFlags()) {
            if (this.lockedFlags.contains(flag)) {
                return false;
            }
            WrappedGoal runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.getGoal() == this.sitGoal || !runningGoal.isRunning() || runningGoal.getPriority() > non_trivial_p) continue;
            return false;
        }
        return true;
    }

    public boolean triggerAction(TriggerableAction action) {
        boolean sitBlock;
        if (action == null) {
            return false;
        }
        if (this.isOtherActionOccupied(action)) {
            return false;
        }
        boolean bl = sitBlock = this.dog.isOrderedToSit() && (this.dog.forceSit() || !action.canOverrideSit());
        if (sitBlock) {
            return false;
        }
        if (action.goBackToSitPosWhenFinished()) {
            this.maySaveDogSittingPos();
        }
        this.dog.setOrderedToSit(false);
        this.putActionInExecutor(action);
        this.delayedActionStart = 0;
        this.timeoutPending = 0;
        return true;
    }

    public void maySaveDogSittingPos() {
        if (!this.dog.isOrderedToSit()) {
            return;
        }
        if (!this.dog.isInSittingPose()) {
            return;
        }
        if (!this.dog.onGround()) {
            return;
        }
        this.dog.setDogSitOverridePos(this.dog.blockPosition());
    }

    private boolean isOtherActionOccupied(TriggerableAction action) {
        Optional<TriggerableAction> activeActionOptional = this.getActiveAction();
        if (!activeActionOptional.isPresent()) {
            return false;
        }
        TriggerableAction activeAction = activeActionOptional.get();
        boolean override_condition = activeAction.isTrivial() && !action.isTrivial();
        return !override_condition;
    }

    private void putActionInExecutor(TriggerableAction action) {
        if (action.isTrivial()) {
            this.trivialActionGoal.setAction(action);
            return;
        }
        TriggerableAction trivialAction = this.trivialActionGoal.getAction();
        if (trivialAction != null) {
            if (trivialAction.canPause()) {
                trivialAction.setState(TriggerableAction.ActionState.PAUSED);
            } else {
                this.trivialActionGoal.clearAction();
            }
        }
        this.nonTrivialActionGoal.setAction(action);
    }

    public boolean triggerActionDelayed(TriggerableAction action, int delayed) {
        boolean ret = this.triggerAction(action);
        if (ret) {
            this.delayedActionStart = delayed;
        }
        return ret;
    }

    public void clearTriggerableAction() {
        this.nonTrivialActionGoal.clearAction();
        this.trivialActionGoal.clearAction();
    }

    public void handleOfflineDog() {
        this.nonTrivialActionGoal.handleOfflineDog();
        this.trivialActionGoal.handleOfflineDog();
    }

    public boolean isActionBlockingSit() {
        Optional<TriggerableAction> actionOptional = this.getActiveAction();
        if (!actionOptional.isPresent()) {
            return false;
        }
        TriggerableAction action = actionOptional.get();
        return action.canPreventSit() && action.getState() == TriggerableAction.ActionState.RUNNING;
    }

    public Optional<TriggerableAction> getActiveAction() {
        TriggerableAction action = null;
        action = this.nonTrivialActionGoal.getAction() != null ? this.nonTrivialActionGoal.getAction() : this.trivialActionGoal.getAction();
        return Optional.ofNullable(action);
    }

    public boolean isSitGoalRunning() {
        if (this.sitGoalWrapped == null) {
            return false;
        }
        return this.sitGoalWrapped.isRunning();
    }

    public void requestFollow() {
        this.followOwnerGoal.requestFollow();
    }

    public static class DogActionExecutorGoal
    extends Goal {
        @Nullable
        private TriggerableAction action = null;
        private final DogAiManager dogAi;
        private final int priority;
        private final boolean isTrivial;

        public DogActionExecutorGoal(DogAiManager dogAi, boolean trivial, int p) {
            this.dogAi = dogAi;
            this.isTrivial = trivial;
            this.priority = p;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.action != null;
        }

        public boolean canContinueToUse() {
            return this.action != null;
        }

        public void setAction(TriggerableAction action) {
            if (this.action != null) {
                this.clearAction();
            }
            this.action = action;
        }

        public void clearAction() {
            if (this.action == null) {
                return;
            }
            this.action.stop();
            this.action = null;
        }

        public void handleOfflineDog() {
            if (this.action == null) {
                return;
            }
            this.action.onDogGoesOfflineWhileActive();
            this.action = null;
        }

        public boolean hasAction() {
            return this.action != null;
        }

        public TriggerableAction getAction() {
            return this.action;
        }

        public void stop() {
            TriggerableAction action = this.action;
            if (action == null) {
                return;
            }
            if (action.getState() == TriggerableAction.ActionState.FINISHED) {
                this.clearAction();
                return;
            }
            if (action.isStarted() && action.canPause()) {
                action.setState(TriggerableAction.ActionState.PAUSED);
                return;
            }
            this.clearAction();
            if (!this.isTrivial) {
                this.dogAi.onNonTrivialActionInterupted();
            }
        }

        public void tick() {
            TriggerableAction action = this.action;
            if (action == null) {
                return;
            }
            if (this.dogAi.delayedActionStart > 0) {
                return;
            }
            TriggerableAction.ActionState state = action.getState();
            boolean shouldTick = false;
            if (state == TriggerableAction.ActionState.PENDING) {
                action.setState(TriggerableAction.ActionState.RUNNING);
                action.start();
            } else if (state == TriggerableAction.ActionState.PAUSED) {
                action.setState(TriggerableAction.ActionState.RUNNING);
                if (action.isStarted()) {
                    shouldTick = true;
                } else {
                    action.start();
                }
            } else if (state == TriggerableAction.ActionState.RUNNING) {
                shouldTick = true;
            }
            if (shouldTick) {
                action.doTick();
            }
            if ((state = action.getState()) == TriggerableAction.ActionState.FINISHED) {
                this.clearAction();
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static interface IHasTickNonRunning {
        public void tickDogWhenNotRunning();
    }
}

