/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DogRangedAttackGoal
extends Goal {
    private static final int default_attack_radius = 20;
    private final Dog dog;
    private final int timeOutTick = 40;
    private int waitingTick;
    private BlockPos.MutableBlockPos dogPos0;
    private int seeTime = 0;
    private int attackCooldown = 0;
    private int tickTillPathRecalc = 0;

    public DogRangedAttackGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target;
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.fallDistance > 7.0) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.getOwner();
            if (owner != null && this.dog.distanceToSqr((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            restriction = !this.dog.patrolTargetLock();
        }
        if ((target = this.dog.getTarget()) == null) {
            return false;
        }
        if (!target.isAlive()) {
            this.dog.setTarget(null);
            return false;
        }
        if (target.getY() >= (double)this.dog.level().getMaxY()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        return !restriction || !this.checkRestriction(target, this.dog);
    }

    public boolean canContinueToUse() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (this.dog.fallDistance > 7.0) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.getOwner();
            if (owner != null && this.dog.distanceToSqr((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            boolean bl = restriction = !this.dog.patrolTargetLock();
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        LivingEntity livingentity = this.dog.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (livingentity.getY() >= (double)this.dog.level().getMaxY()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (restriction && this.checkRestriction(livingentity, this.dog)) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
    }

    private boolean checkRestriction(LivingEntity target, Dog dog) {
        BlockPos restrict_pos = dog.getDogRestrictCenter();
        if (restrict_pos == null) {
            return false;
        }
        int restrict_r = dog.getDogRestrictRadius();
        if (restrict_r < 0) {
            return false;
        }
        float max_dist = this.getAttackRadius(target) - 2.0f + (float)restrict_r;
        return !(target.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)restrict_pos)) <= (double)(max_dist * max_dist));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected double getMaxDistanceAwayFromOwner() {
        if (this.dog.getCombatReturnStrategy() == Dog.CombatReturnStrategy.FAR) {
            return 1024.0;
        }
        return 400.0;
    }

    public void start() {
        this.seeTime = 0;
        this.tickTillPathRecalc = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.blockPosition().mutable();
        this.dog.getDogRangedAttack().onStart(this.dog);
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = true;
        if (attack_manager.hasTaticalTarget()) {
            attack_manager.setDogFarChasingTarget(true);
        }
    }

    public void stop() {
        this.seeTime = 0;
        this.attackCooldown = -1;
        this.dog.getDogRangedAttack().onStop(this.dog);
        this.dog.getNavigation().stop();
        this.dog.setTarget(null);
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = false;
        attack_manager.setDogFarChasingTarget(false);
    }

    public void tick() {
        double min_dist;
        double d0;
        LivingEntity target = this.dog.getTarget();
        if (target == null) {
            return;
        }
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.isDogFarChasingTarget() && (d0 = this.dog.distanceToSqr(target.getX(), target.getY(), target.getZ())) < (min_dist = (double)(attack_manager.getStandardFollowRange() / 2 + 1)) * min_dist) {
            attack_manager.setDogFarChasingTarget(false);
        }
        double d_dog_target_sqr = this.dog.distanceToSqr(target.getX(), target.getY(), target.getZ());
        boolean can_see_target = this.dog.getSensing().hasLineOfSight((Entity)target);
        this.updateSeeTime(can_see_target);
        this.chaseTargetOrPositionSelf(target, d_dog_target_sqr, can_see_target);
        this.updateUsingWeapon(can_see_target, target);
    }

    private float getAttackRadius(LivingEntity target) {
        if (!this.dog.isDefaultNavigation()) {
            return 6.0f + target.getBbWidth() / 2.0f;
        }
        return 20.0f;
    }

    private void updateSeeTime(boolean canSeeTarget) {
        boolean was_seeing_target;
        boolean bl = was_seeing_target = this.seeTime > 0;
        if (canSeeTarget != was_seeing_target) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
    }

    private void chaseTargetOrPositionSelf(LivingEntity target, double d_dog_target_sqr, boolean can_see_target) {
        boolean should_chase_target;
        float attack_r = this.getAttackRadius(target);
        boolean bl = should_chase_target = d_dog_target_sqr > (double)(attack_r * attack_r) || this.seeTime < -40;
        if (should_chase_target) {
            this.chaseTarget(target);
        } else {
            this.positionSelf(target, d_dog_target_sqr, can_see_target);
        }
    }

    private void chaseTarget(LivingEntity target) {
        BlockPos dog_bp = this.dog.blockPosition();
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.set(dog_bp.getX(), dog_bp.getY(), dog_bp.getZ());
        }
        this.dog.getLookControl().setLookAt((Entity)target, 30.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            this.dog.getNavigation().moveTo((Entity)target, 1.0);
        }
    }

    private void positionSelf(LivingEntity target, double d_dog_target_sqr, boolean can_see_target) {
        this.dog.getNavigation().stop();
        this.waitingTick = 0;
        this.dog.getLookControl().setLookAt((Entity)target, 30.0f, (float)this.dog.getMaxHeadXRot());
        this.dog.lookAt((Entity)target, 30.0f, this.dog.getMaxHeadXRot());
        if (this.dog.isDefaultNavigation()) {
            this.strafeAtTarget(target, d_dog_target_sqr);
        }
    }

    private void updateUsingWeapon(boolean can_see_target, LivingEntity target) {
        boolean attacked;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (attacked = this.dog.getDogRangedAttack().updateUsingWeapon(new IDogRangedAttackManager.UsingWeaponContext(this.dog, can_see_target, this.seeTime, this.attackCooldown, target))) {
            this.attackCooldown = 20;
        }
    }

    private void strafeAtTarget(LivingEntity target, double d_dog_target_sqr) {
        int strafe_dir = 0;
        double foward_threshold = this.getAttackRadius(target) * 0.75f;
        double backup_threshold = 6.0;
        if (d_dog_target_sqr > foward_threshold * foward_threshold) {
            strafe_dir = 1;
        } else if (d_dog_target_sqr < backup_threshold * backup_threshold) {
            strafe_dir = -1;
        }
        this.dog.getMoveControl().strafe((float)strafe_dir * 0.5f, 0.0f);
    }
}

