/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class DogFlyingNavigation
extends FlyingPathNavigation
implements IDogNavLock {
    private Dog dog;
    private boolean locked;

    public DogFlyingNavigation(Dog dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    public void tick() {
        super.tick();
    }

    public boolean canDashToTarget(LivingEntity target) {
        return this.canMoveDirectly(this.dog.position(), target.position());
    }

    protected boolean canUpdatePath() {
        return super.canUpdatePath() && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void recomputePath() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.recomputePath();
        this.locked = prevLock;
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected Path createPath(@Nonnull Set<BlockPos> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.createPath(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }
}

