/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DogMoveToBedAction
extends TriggerableAction {
    @Nonnull
    private final BlockPos targetBedPos;
    private final boolean claimBed;
    private boolean bedReached = false;
    private int timeOut;

    public DogMoveToBedAction(Dog dog, @Nonnull BlockPos targetBedPos, boolean claimBed) {
        super(dog, false, false);
        this.targetBedPos = targetBedPos;
        this.claimBed = claimBed;
    }

    @Override
    public void onStart() {
        this.timeOut = 400;
        if (this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.targetBedPos)) >= 400.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.getNavigation().moveTo((double)this.targetBedPos.getX() + 0.5, (double)(this.targetBedPos.getY() + 1), (double)this.targetBedPos.getZ() + 0.5, 1.0);
    }

    @Override
    public void tick() {
        --this.timeOut;
        if (this.timeOut <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        boolean bl = this.bedReached = this.dog.blockPosition().distSqr((Vec3i)this.targetBedPos) <= 1.5;
        if (this.dog.getNavigation().isDone()) {
            if (this.bedReached) {
                if (this.claimBed) {
                    this.claimBed();
                }
                this.dog.setOrderedToSit(true);
            }
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    private void claimBed() {
        BlockPos target = this.targetBedPos;
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)this.dog.level(), target, DogBedTileEntity.class);
        if (dogBedTileEntity == null) {
            return;
        }
        if (dogBedTileEntity.getOwnerUUID() != null) {
            return;
        }
        dogBedTileEntity.setOwner(this.dog);
        this.dog.setBedPos((ResourceKey<Level>)this.dog.level().dimension(), target);
        this.dog.level().broadcastEntityEvent((Entity)this.dog, (byte)7);
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }
}

