/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory;

import doggytalents.api.backward_imitate.CodecUtil_1_21_7;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ItemUtil_1_21_3;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.DogArmorItemHandler;
import doggytalents.common.util.ItemUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public class DogArmorItemHandlerImpl
extends DogArmorItemHandler {
    public DogArmorItemHandlerImpl(AbstractDog dog) {
        super(dog);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider prov) {
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            itemsList.add((Object)CodecUtil_1_21_7.saveItemStack(stack, prov, itemTag));
        }
        CompoundTag compound = new CompoundTag();
        compound.put("dogArmors", (Tag)itemsList);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider prov, CompoundTag compound_1_21_5) {
        CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
        if (compound.contains("dogArmors", 9)) {
            ListTag_1_21_5 tagList = compound.getList("dogArmors", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                ItemStack stack = CodecUtil_1_21_7.parseItemStack(prov, itemTag.wrapped()).orElse(ItemStack.EMPTY);
                this.setArmorInSlot(stack);
            }
            this.onLoad();
        }
    }

    public void setArmorInSlot(ItemStack stack) {
        Item item = stack.getItem();
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return;
        }
        EquipmentSlot slot = ItemUtil_1_21_3.getEquipmentSlot(stack);
        this.setArmorInSlot(stack, slot);
    }

    public void setArmorInSlot(ItemStack stack, EquipmentSlot slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return;
        }
        this.stacks.set(dogSlot.slotId, (Object)stack);
    }

    public ItemStack getArmorFromSlot(EquipmentSlot slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(dogSlot.slotId);
    }

    public Iterable<ItemStack> armors() {
        return this.stacks;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        boolean is_depth_strider;
        if (!this.dog.canDogWearArmor()) {
            return false;
        }
        DogArmorSlots dogSlot = DogArmorSlots.bySlotId(slot);
        if (dogSlot == null) {
            return false;
        }
        EquipmentSlot equip = dogSlot.val;
        Item item = stack.getItem();
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return false;
        }
        EquipmentSlot wantSlot = ItemUtil_1_21_3.getEquipmentSlot(stack);
        if (wantSlot != equip) {
            return false;
        }
        boolean bl = is_depth_strider = wantSlot == EquipmentSlot.FEET && ItemUtil.getEnchantmentLevelForItem((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, this.dog.level().registryAccess(), stack) > 0;
        return !is_depth_strider;
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (props.canWearArmor()) {
            return;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public static enum DogArmorSlots {
        HEAD(0, EquipmentSlot.HEAD),
        CHEST(1, EquipmentSlot.CHEST),
        LEGS(2, EquipmentSlot.LEGS),
        FEET(3, EquipmentSlot.FEET);

        public final int slotId;
        public final EquipmentSlot val;

        private DogArmorSlots(int slotId, EquipmentSlot val) {
            this.slotId = slotId;
            this.val = val;
        }

        public static DogArmorSlots bySlotId(int slotId) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.slotId != slotId) continue;
                return val;
            }
            return null;
        }

        public static DogArmorSlots byEquipment(EquipmentSlot slot) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.val != slot) continue;
                return val;
            }
            return null;
        }
    }
}

