/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.DogArmorItemHandlerImpl;
import doggytalents.common.util.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DogArmorContainer
extends AbstractContainerMenu {
    private Level world;
    private Player player;
    private Dog dog;
    public static final ResourceLocation BLOCK_ATLAS = Util.getVanillaResource("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = Util.getVanillaResource("container/slot/helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = Util.getVanillaResource("container/slot/chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = Util.getVanillaResource("container/slot/leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = Util.getVanillaResource("container/slot/boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = Util.getVanillaResource("container/slot/shield");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public DogArmorContainer(int windowId, Inventory playerInventory, final Dog dog) {
        super(DoggyContainerTypes.DOG_ARMOR.get(), windowId);
        DogArmorItemHandlerImpl.DogArmorSlots dogSlot;
        EquipmentSlot equipmentslot;
        int i;
        this.world = playerInventory.player.level();
        this.player = playerInventory.player;
        this.dog = dog;
        DogArmorItemHandlerImpl dogArmors = dog.dogArmors();
        for (i = 0; i < 2; ++i) {
            equipmentslot = SLOT_IDS[i];
            dogSlot = DogArmorItemHandlerImpl.DogArmorSlots.byEquipment(equipmentslot);
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dogArmors, dogSlot.slotId, 17, 27 + i * 18){

                public void set(ItemStack p_219985_) {
                    ItemStack itemstack = this.getItem();
                    super.set(p_219985_);
                    dog.onEquipItem(equipmentslot, itemstack, p_219985_);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public ResourceLocation getNoItemIcon() {
                    return TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()];
                }
            });
        }
        for (i = 2; i < 4; ++i) {
            equipmentslot = SLOT_IDS[i];
            dogSlot = DogArmorItemHandlerImpl.DogArmorSlots.byEquipment(equipmentslot);
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dogArmors, dogSlot.slotId, 138, 27 + (i - 2) * 18){

                public void set(ItemStack p_219985_) {
                    ItemStack itemstack = this.getItem();
                    super.set(p_219985_);
                    dog.onEquipItem(equipmentslot, itemstack, p_219985_);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public ResourceLocation getNoItemIcon() {
                    return TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()];
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 4 ? !this.moveItemStackTo(itemstack1, 4, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 4, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player p_38874_) {
        return this.dog.isDoingFine() && this.dog.getDogLevel(DoggyTalents.DOGGY_ARMOR.get()) > 0;
    }

    public Dog getDog() {
        return this.dog;
    }
}

