/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RiceMillMenu
extends AbstractContainerMenu {
    private int grainSlotEnd;
    private int bowlSlotId;
    private int outputSlotId;
    private int playerInventoryBegin;
    private Container millContainer;
    private ContainerData syncedData;
    private RiceMillBlockEntity clientMill = null;

    public RiceMillMenu(int containerId, Inventory inv, BlockPos millPos) {
        this(containerId, inv, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(2));
        Player player = inv.player;
        Level level = player.level();
        if (level.isClientSide) {
            this.findClientMill(level, millPos);
        }
    }

    private void findClientMill(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        this.clientMill = mill;
    }

    public RiceMillBlockEntity getClientMill() {
        return this.clientMill;
    }

    public RiceMillMenu(int containerId, Inventory inv, Container millContainer, ContainerData syncedData) {
        super(DoggyContainerTypes.RICE_MILL.get(), containerId);
        RiceMillMenu.checkContainerSize((Container)millContainer, (int)3);
        RiceMillMenu.checkContainerDataCount((ContainerData)syncedData, (int)2);
        this.millContainer = millContainer;
        this.syncedData = syncedData;
        for (int i = 0; i < RiceMillBlockEntity.GRAIN_SLOTS.length; ++i) {
            int grainSlot = RiceMillBlockEntity.GRAIN_SLOTS[i];
            this.addSlot(new Slot(this, millContainer, grainSlot, 20, 17 + (i + 1) * 18){

                public boolean mayPlace(ItemStack stack) {
                    return RiceMillBlockEntity.isInputSlotValid(stack);
                }
            });
        }
        this.grainSlotEnd = RiceMillBlockEntity.GRAIN_SLOTS.length - 1;
        Slot bowlSlot = this.addSlot(new Slot(this, millContainer, 1, 58, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.BOWL);
            }
        });
        this.bowlSlotId = bowlSlot.index;
        Slot outputSlot = this.addSlot(new Slot(this, millContainer, RiceMillBlockEntity.OUTPUT_SLOT[0], 116, 35){

            public boolean mayPlace(ItemStack p_40231_) {
                return false;
            }
        });
        this.outputSlotId = outputSlot.index;
        this.playerInventoryBegin = this.outputSlotId + 1;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
        this.addDataSlots(syncedData);
    }

    public ItemStack quickMoveStack(Player player, int clickedSlotId) {
        Slot clickedSlot = (Slot)this.slots.get(clickedSlotId);
        if (clickedSlot == null || !clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack clickedItem = clickedSlot.getItem();
        ItemStack clickedItem0 = clickedItem.copy();
        boolean moveResult = false;
        moveResult = clickedSlotId >= this.playerInventoryBegin ? this.moveItemStackTo(clickedItem, 0, this.playerInventoryBegin, false) : this.moveItemStackTo(clickedItem, this.playerInventoryBegin, this.slots.size(), false);
        if (!moveResult) {
            return ItemStack.EMPTY;
        }
        if (clickedItem.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        if (clickedItem.getCount() == clickedItem0.getCount()) {
            return ItemStack.EMPTY;
        }
        return clickedItem0;
    }

    public boolean stillValid(Player player) {
        return this.millContainer.stillValid(player);
    }

    public float getGrindProgress() {
        float grindTime = this.syncedData.get(0);
        float finishTime = this.syncedData.get(1);
        float ret = grindTime / finishTime;
        return Mth.clamp((float)ret, (float)0.0f, (float)1.0f);
    }
}

