/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.recipe;

import doggytalents.DoggyRecipeSerializers;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.IDogBedMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.util.DogBedUtil;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DogBedRecipe
extends CustomRecipe {
    public DogBedRecipe(CraftingBookCategory p_249010_) {
        super(p_249010_);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        if (inv.width() != 3 || inv.height() != 3) {
            return false;
        }
        IDogBedMaterial beddingId = null;
        IDogBedMaterial casingId = null;
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                IDogBedMaterial id;
                Optional<IDogBedMaterial> material_optional;
                if (col == 1 && row < 2) {
                    material_optional = DogBedUtil.getBeddingFromStack(inv.getItem(col, row));
                    if (!material_optional.isPresent()) {
                        return false;
                    }
                    id = (IBeddingMaterial)material_optional.get();
                    if (beddingId == null) {
                        beddingId = id;
                        continue;
                    }
                    if (beddingId == id) continue;
                    return false;
                }
                material_optional = DogBedUtil.getCasingFromStack(inv.getItem(col, row));
                if (!material_optional.isPresent()) {
                    return false;
                }
                id = (ICasingMaterial)material_optional.get();
                if (casingId == null) {
                    casingId = id;
                    continue;
                }
                if (casingId == id) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return DoggyRecipeSerializers.DOG_BED.get();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider p_267165_) {
        IBeddingMaterial beddingId = DogBedUtil.getBeddingFromStack(inv.getItem(1)).orElse(DogBedMaterialManager.NaniBedding.NULL);
        ICasingMaterial casingId = DogBedUtil.getCasingFromStack(inv.getItem(0)).orElse(DogBedMaterialManager.NaniCasing.NULL);
        return DogBedUtil.createItemStack(casingId, beddingId);
    }
}

