/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.backward_imitate.DogFoodProperties_21_3;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.network.packet.ParticlePackets;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class DogEddibleItem
extends Item
implements IDogEddible,
HoverTextAppender_1_21_5 {
    private final FoodProperties foodProps;
    private List<DogFoodProperties_21_3.PossibleEffect_1_21_3> dogEffects_21_3;

    public DogEddibleItem(Item.Properties itemProps, DogFoodProperties_21_3 foodProps) {
        super(itemProps.food(foodProps.getVanillaProps().build(), foodProps.getVanillaEffects()));
        this.foodProps = foodProps.getVanillaProps().build();
        this.init_1_21_3(foodProps);
    }

    public DogEddibleItem(Item.Properties itemProps, Function<DogFoodProperties_21_3, DogFoodProperties_21_3> propsCreator) {
        this(itemProps, propsCreator.apply(new DogFoodProperties_21_3()));
    }

    public DogEddibleItem(Item.Properties itemProps, Function<Item.Properties, Item.Properties> itemPropsCreator, Function<DogFoodProperties_21_3, DogFoodProperties_21_3> propsCreator) {
        this(itemPropsCreator.apply(itemProps), propsCreator.apply(new DogFoodProperties_21_3()));
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.getItem() == this;
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        return !dog.isDefeated() && this.isFood(stackIn);
    }

    @Override
    public DogInteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        if (dog.level().isClientSide) {
            return DogInteractionResult.SUCCESS;
        }
        DogEddibleItem dogEddible = this;
        if (!dogEddible.alwaysEatWhenDogConsume(dog) && !dog.canStillEat()) {
            return DogInteractionResult.FAIL;
        }
        if (!dog.level().isClientSide) {
            float heal = dogEddible.getAddedHungerWhenDogConsume(stack, dog);
            dog.addHunger(heal);
            dog.consumeItemFromStack(entityIn, stack);
            for (DogFoodProperties_21_3.PossibleEffect_1_21_3 pair : dogEddible.getAdditionalEffectsWhenDogConsume(stack, dog)) {
                if (!(dog.getRandom().nextFloat() < pair.probability())) continue;
                dog.addEffect(pair.effect());
            }
            if (dog.level() instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)this));
            }
            dog.playSound(dogEddible.getDogEatingSound(dog), dog.getSoundVolume(), (dog.getRandom().nextFloat() - dog.getRandom().nextFloat()) * 0.2f + 1.0f);
            ItemStack returnStack = dogEddible.getReturnStackAfterDogConsume(stack, dog);
            if (!returnStack.isEmpty()) {
                dog.spawnAtLocation((ServerLevel)dog.level(), returnStack);
            }
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public float getAddedHungerWhenDogConsume(ItemStack useStack, AbstractDog dog) {
        return this.foodProps.nutrition() * 5;
    }

    @Override
    public List<DogFoodProperties_21_3.PossibleEffect_1_21_3> getAdditionalEffectsWhenDogConsume(ItemStack useStack, AbstractDog dog) {
        return this.dogEffects_21_3;
    }

    public void init_1_21_3(DogFoodProperties_21_3 props) {
        this.dogEffects_21_3 = props.dogEffects();
    }
}

