/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RiceGrainsItem
extends BlockItem
implements HoverTextAppender_1_21_5 {
    public RiceGrainsItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40565_, p_40566_);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.handleGrindStoneUsage(context).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private DogInteractionResult handleGrindStoneUsage(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        InteractionHand hand = context.getHand();
        Player player = context.getPlayer();
        if (!state.is(Blocks.GRINDSTONE)) {
            return DogInteractionResult.FAIL;
        }
        level.playSound((Entity)player, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level.isClientSide) {
            return DogInteractionResult.SUCCESS;
        }
        ItemStack resultStack = new ItemStack((ItemLike)DoggyItems.UNCOOKED_RICE.get(), stack.getCount());
        ItemEntity resultEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, resultStack);
        level.addFreshEntity((Entity)resultEntity);
        if (player != null) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = "block.doggytalents.rice_crop.description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

