/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.item.DogAnimDebugItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogAnimDebugData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DogAnimDebugPackets {

    public static class UpdateItemSettings
    implements IPacket<DogAnimDebugData.UpdateItemSettingsData> {
        @Override
        public void encode(DogAnimDebugData.UpdateItemSettingsData data, FriendlyByteBuf buf) {
            buf.writeInt(data.selected.getId());
            buf.writeInt(data.mode.getId());
        }

        @Override
        public DogAnimDebugData.UpdateItemSettingsData decode(FriendlyByteBuf buf) {
            DogAnimation selected = DogAnimation.byId(buf.readInt());
            DogAnimDebugItem.ItemMode mode = DogAnimDebugItem.ItemMode.fromId(buf.readInt());
            return new DogAnimDebugData.UpdateItemSettingsData(selected, mode);
        }

        @Override
        public void handle(DogAnimDebugData.UpdateItemSettingsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                ItemStack stack = sender.getMainHandItem();
                DogAnimDebugItem.editDebugAnimStack(stack, data.selected, data.mode);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

