/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogMountData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class DogMountPacket
implements IPacket<DogMountData> {
    @Override
    public void encode(DogMountData data, FriendlyByteBuf buf) {
        buf.writeInt(data.dogId);
        buf.writeBoolean(data.mount);
    }

    @Override
    public DogMountData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean mount = buf.readBoolean();
        return new DogMountData(id, mount);
    }

    @Override
    public void handle(DogMountData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                ClientEventHandler.onDogMountEvent(data);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

