/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ForceChangeOwnerData;
import doggytalents.common.util.PlayerUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ObjectUtils;

public class ForceChangeOwnerPacket
extends DogPacket<ForceChangeOwnerData> {
    @Override
    public void encode(ForceChangeOwnerData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
    }

    @Override
    public ForceChangeOwnerData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        return new ForceChangeOwnerData(id);
    }

    @Override
    public void handleDog(Dog dog, ForceChangeOwnerData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!sender.hasPermissions(4)) {
            return;
        }
        if (!sender.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = sender.getMainHandItem();
        if (!stack.is(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        if (PlayerUtil.isOnCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID currentOwnerUUID = dog.getOwnerUUID();
        UUID newOwnerUUID = sender.getUUID();
        if (newOwnerUUID == null) {
            return;
        }
        if (!ObjectUtils.notEqual((Object)newOwnerUUID, (Object)currentOwnerUUID)) {
            return;
        }
        dog.migrateOwner(newOwnerUUID);
        PlayerUtil.addCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get(), 40);
    }
}

