/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FireDrillTalent
extends TalentInstance {
    private int rollCooldown = 0;
    private boolean fireExtinguished = false;
    private boolean isInFire = false;
    private boolean isRolling = false;
    private int tickTillUpdateInFire = 10;

    public FireDrillTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.rollCooldown > 0) {
            --this.rollCooldown;
        }
        if (dog.getRemainingFireTicks() >= 20 || this.isRolling) {
            this.updateInFire(dog);
            if (this.canRoll(dog)) {
                dog.triggerAction(new DogStopDropRollAction(dog, this));
                this.rollCooldown = 40;
            }
        }
    }

    private void updateInFire(Dog dog) {
        if (--this.tickTillUpdateInFire > 0) {
            return;
        }
        this.tickTillUpdateInFire = 10;
        this.isInFire = true;
        AABB bb = dog.getBoundingBox();
        BlockPos startPos = BlockPos.containing((double)bb.minX, (double)bb.minY, (double)bb.minZ);
        BlockPos endPos = BlockPos.containing((double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)startPos, (BlockPos)endPos)) {
            BlockState state = dog.level().getBlockState(pos);
            if (!(state.getBlock() instanceof FireBlock)) continue;
            return;
        }
        this.isInFire = false;
    }

    private boolean canRoll(Dog dog) {
        if (this.rollCooldown > 0) {
            return false;
        }
        if (this.isInFire) {
            return false;
        }
        if (!dog.onGround()) {
            return false;
        }
        if (dog.isInSittingPose()) {
            return false;
        }
        if (!dog.canDoIdileAnim()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.getTarget() == null;
    }

    private boolean canContinueToRoll(Dog dog) {
        if (this.isInFire) {
            return false;
        }
        if (!dog.onGround()) {
            return false;
        }
        if (dog.isInSittingPose()) {
            return false;
        }
        if (!dog.canContinueDoIdileAnim()) {
            return false;
        }
        return !this.fireExtinguished || !dog.isOnFire();
    }

    @Override
    public DogInteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, DamageSource source, float amount) {
        if (this.isRolling && source.is(DamageTypes.ON_FIRE)) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    public static class DogStopDropRollAction
    extends TriggerableAction {
        private int stopTick;
        private int tickTillExtinguish = 60;
        private FireDrillTalent talentInst;

        public DogStopDropRollAction(Dog dog, FireDrillTalent talentInst) {
            super(dog, false, false);
            this.talentInst = talentInst;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.tickCount + DogAnimation.STOP_DROP_ROLL.getLengthTicks();
            this.dog.setAnimForIdle(DogAnimation.STOP_DROP_ROLL);
            this.talentInst.fireExtinguished = false;
            this.talentInst.isRolling = true;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.STOP_DROP_ROLL) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.tickCount >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.canContinueToRoll(this.dog)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            --this.tickTillExtinguish;
            if (this.tickTillExtinguish == 0 && this.dog.isOnFire()) {
                this.dog.clearFire();
                this.dog.playSound(SoundEvents.FIRE_EXTINGUISH, 0.5f, 2.6f + this.dog.getRandom().nextFloat() - this.dog.getRandom().nextFloat() * 0.8f);
                this.talentInst.fireExtinguished = true;
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.STOP_DROP_ROLL) {
                this.dog.setAnim(DogAnimation.NONE);
            }
            this.talentInst.rollCooldown = 40;
            this.talentInst.isRolling = false;
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }

        @Override
        public boolean canPreventSit() {
            return true;
        }
    }
}

