/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogFlyingMoveControl;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.common.util.Util;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class FlyingFurballTalent
extends TalentInstance {
    private static ResourceLocation FLYING_FURBALL_BOOST_UUID = Util.getResource("flying_furball_boost");
    private static ResourceLocation FLYING_FURBALL_GRAVITY_UUID = Util.getResource("flying_furball_gravity");
    private DogFlyingMoveControl moveControl;
    private DogFlyingNavigation navigation;
    private boolean startedGliding = false;
    private boolean wasFlying = false;
    private int flyHoldTick = 0;
    private boolean allowFlying = true;

    public FlyingFurballTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        if (dog.level().isClientSide) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        d.setAttributeModifier((Holder<Attribute>)Attributes.FLYING_SPEED, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
        this.moveControl = new DogFlyingMoveControl(d, this);
        this.navigation = new DogFlyingNavigation(d, dog.level());
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier((Holder<Attribute>)Attributes.FLYING_SPEED, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dogIn) {
        Dog d;
        if (dogIn.level().isClientSide) {
            return;
        }
        dogIn.removeAttributeModifier((Holder<Attribute>)Attributes.FLYING_SPEED, FLYING_FURBALL_BOOST_UUID);
        dogIn.resetMoveControl();
        dogIn.resetNavigation();
        dogIn.setDogFlying(false);
        this.stopGliding(dogIn);
        dogIn.setNoGravity(false);
        if (dogIn instanceof Dog && (d = (Dog)dogIn).getAnim() == DogAnimation.FLY_AIR_BOURNE) {
            d.setAnim(DogAnimation.NONE);
        }
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        dog.fallDistance = 0.0;
        if (this.flyHoldTick > 0) {
            --this.flyHoldTick;
        }
        boolean isDogFlying = dog.isDogFlying();
        if (dog.getNavigation() != this.navigation && this.shouldSwitchToFlying(dog)) {
            dog.setMoveControl((MoveControl)this.moveControl);
            dog.setNavigation((PathNavigation)this.navigation);
            this.startGliding(dog);
        } else if (dog.getNavigation() == this.navigation && this.shouldSwitchAwayFromFlying(dog)) {
            dog.resetMoveControl();
            dog.resetNavigation();
            this.stopGliding(dog);
        }
        if (isDogFlying && this.shouldStopFlying(dog)) {
            dog.setDogFlying(false);
            dog.setNoGravity(false);
        }
        if (!isDogFlying && this.canBeginFlying(dog)) {
            dog.setDogFlying(true);
            this.flyHoldTick = 15;
        }
        if (isDogFlying = dog.isDogFlying()) {
            if (this.wasFlying) {
                if (dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                    dog.setAnim(DogAnimation.FLY_AIR_BOURNE);
                }
            } else {
                dog.setAnim(DogAnimation.FLY_JUMP_START);
                this.wasFlying = true;
            }
        }
        if (!isDogFlying) {
            DogAnimation anim = dog.getAnim();
            if (anim == DogAnimation.FLY_AIR_BOURNE || anim == DogAnimation.FLY_JUMP_START || this.wasFlying && anim == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                dog.setAnim(DogAnimation.FLY_LANDING);
            }
            this.wasFlying = false;
        }
    }

    private boolean canBeginFlying(AbstractDog dog) {
        return dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim() && this.shouldBeFlying(dog);
    }

    private boolean shouldStopFlying(AbstractDog dog) {
        return !this.shouldBeFlying(dog);
    }

    private boolean shouldBeFlying(AbstractDog dog) {
        if (this.flyHoldTick > 0) {
            return true;
        }
        if (!dog.isDoingFine() && dog instanceof Dog) {
            Dog ddog = (Dog)dog;
            if (!ddog.incapacitatedMananger.canMove()) {
                return false;
            }
        }
        return this.allowFlying() && !dog.onGround() && !dog.isInSittingPose() && !dog.isPassenger() && !dog.isInWater() && dog.getNavigation() == this.navigation;
    }

    private boolean shouldSwitchToFlying(AbstractDog dog) {
        return this.allowFlying() && !dog.isInSittingPose() && !dog.isPassenger() && !dog.isInWater();
    }

    private boolean shouldSwitchAwayFromFlying(AbstractDog dog) {
        return !this.allowFlying();
    }

    public AttributeModifier createSpeedModifier(AbstractDog dogIn, ResourceLocation uuidIn) {
        if (this.level() > 0) {
            double speed = (double)(this.level() - 1) * 0.1;
            return new AttributeModifier(uuidIn, speed, AttributeModifier.Operation.ADD_VALUE);
        }
        return null;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanFly().setWillFly(this::allowFlying).setFallImmune();
    }

    public void startGliding(AbstractDog dog) {
        this.startedGliding = true;
        dog.setAttributeModifier((Holder<Attribute>)Attributes.GRAVITY, FLYING_FURBALL_GRAVITY_UUID, this::createGravityModifier);
    }

    public void stopGliding(AbstractDog dog) {
        if (!this.startedGliding) {
            return;
        }
        this.startedGliding = false;
        dog.removeAttributeModifier((Holder<Attribute>)Attributes.GRAVITY, FLYING_FURBALL_GRAVITY_UUID);
    }

    public AttributeModifier createGravityModifier(AbstractDog dogIn, ResourceLocation uuidIn) {
        return new AttributeModifier(uuidIn, -0.8, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.allowFlying = compound.getBoolean("allowFlying");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.putBoolean("allowFlying", this.allowFlying);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            return this.allowFlying;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            this.allowFlying = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FLYING_FURBALL_ALLOW.get());
    }

    public boolean allowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean val) {
        this.allowFlying = val;
    }
}

