/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.talent.doggy_tools.DogBridging;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.util.DogUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DogBridgingAction
extends TriggerableAction {
    private Phase phase = Phase.GO_TO_INITIAL_POS;
    private final DoggyToolsTalent toolsTalent;
    private final LivingEntity owner;
    private BlockPos initialPos;
    private Direction bridgingDir;
    private int bridgingY = 0;
    private BlockPos nextPos = null;
    private BlockPos prevPos = null;
    private int bridgeCooldown;

    public DogBridgingAction(Dog dog, LivingEntity owner, float bridgingRot, BlockPos initialPos, DoggyToolsTalent talent) {
        super(dog, false, false);
        this.owner = owner;
        this.toolsTalent = talent;
        this.initialPos = initialPos;
        this.bridgingDir = Direction.fromYRot((double)bridgingRot);
    }

    @Override
    public void onStart() {
        Path path = this.dog.getNavigation().createPath(this.initialPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.initialPos, 1, this.dog.getMaxFallDistance())) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.phase = Phase.GO_TO_INITIAL_POS;
        this.dog.getNavigation().moveTo(path, 1.0);
        PathNavigation pathNavigation = this.dog.getNavigation();
        if (pathNavigation instanceof DogPathNavigation) {
            DogPathNavigation dogNav = (DogPathNavigation)pathNavigation;
            dogNav.setDogMoveInTargetNode();
        }
        DogBridging.equipBridgingStack(this.toolsTalent, this.dog);
    }

    @Override
    public void tick() {
        if (!DogBridging.isValidBridgingDog(this.toolsTalent, this.dog)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.phase == Phase.GO_TO_INITIAL_POS) {
            this.goToInitialPos();
        } else {
            this.doBridge();
        }
    }

    private void goToInitialPos() {
        if (this.dog.getNavigation().isDone()) {
            this.phase = Phase.BRIDGE;
            this.nextPos = this.getNextPos();
            this.bridgingY = this.dog.blockPosition().getY();
            return;
        }
    }

    private void doBridge() {
        NextPosAction next_pos_action;
        if (this.bridgeCooldown > 0) {
            --this.bridgeCooldown;
        }
        if (this.dog.blockPosition().getY() != this.bridgingY) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.owner.isAlive() || this.owner.isSpectator() || this.owner.distanceToSqr((Entity)this.dog) >= 144.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.nextPos == null) {
            this.nextPos = this.getNextPos();
        }
        if ((next_pos_action = this.getNextPosAction(this.nextPos)) == NextPosAction.STOP) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.getLookControl().setLookAt(Vec3.atBottomCenterOf((Vec3i)this.nextPos));
        if (next_pos_action == NextPosAction.GO) {
            GoState go_state = this.getGoState(this.nextPos);
            if (go_state == GoState.TOO_FAR) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (go_state == GoState.NOT_REACHED) {
                Vec3 go_pos = Vec3.atBottomCenterOf((Vec3i)this.nextPos);
                this.dog.getMoveControl().setWantedPosition(go_pos.x, go_pos.y, go_pos.z, 0.5);
            } else {
                this.nextPos = null;
            }
        } else if (next_pos_action == NextPosAction.BRIDGE && this.bridgeCooldown <= 0 && !this.tryBridge(this.nextPos)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    private BlockPos getNextPos() {
        return this.dog.blockPosition().relative(this.bridgingDir);
    }

    private NextPosAction getNextPosAction(BlockPos pos) {
        PathType path_type = this.dog.getBlockPathTypeViaAlterations(pos);
        if (path_type == PathType.OPEN) {
            return NextPosAction.BRIDGE;
        }
        if (path_type == PathType.WALKABLE) {
            return NextPosAction.GO;
        }
        return NextPosAction.STOP;
    }

    private GoState getGoState(BlockPos pos) {
        float near_dist = 0.45f;
        float far_dist = 2.0f;
        double dist_sqr = this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)pos));
        if (dist_sqr >= 4.0) {
            return GoState.TOO_FAR;
        }
        if (dist_sqr <= 0.20249998569488525) {
            return GoState.REACHED;
        }
        return GoState.NOT_REACHED;
    }

    private boolean tryBridge(BlockPos pos) {
        pos = pos.below();
        if (this.prevPos != null && this.prevPos.equals((Object)pos)) {
            return false;
        }
        BlockState state = this.dog.level().getBlockState(pos);
        if (!state.isAir()) {
            return false;
        }
        Optional<Pair<ItemStack, BlockItem>> pair_optional = DogBridging.getBridgingMaterial(this.toolsTalent, this.dog);
        if (!pair_optional.isPresent()) {
            return false;
        }
        Pair<ItemStack, BlockItem> pair = pair_optional.get();
        ((BlockItem)pair.getRight()).place(this.getBlockPlaceContext(pos, (ItemStack)pair.getLeft()));
        if (((ItemStack)pair.getLeft()).isEmpty()) {
            DogBridging.getBridgingMaterial(this.toolsTalent, this.dog).ifPresent(x -> this.dog.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)x.getLeft()));
        }
        this.bridgeCooldown = 15;
        this.prevPos = pos;
        return true;
    }

    private BlockPlaceContext getBlockPlaceContext(BlockPos place_pos, ItemStack stack) {
        return new BlockPlaceContext(this.dog.level(), null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)place_pos), Direction.UP, place_pos, false));
    }

    @Override
    public void onStop() {
        if (this.isStarted()) {
            this.dog.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        DogBridging.onBridgingActionStop(this.owner);
    }

    @Override
    public void onDogGoesOfflineWhileActive() {
        DogBridging.onBridgingActionStop(this.owner);
    }

    private static enum Phase {
        GO_TO_INITIAL_POS,
        BRIDGE;

    }

    private static enum NextPosAction {
        GO,
        STOP,
        BRIDGE;

    }

    private static enum GoState {
        REACHED,
        NOT_REACHED,
        TOO_FAR;

    }
}

