/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.IDogBedMaterial;
import doggytalents.common.backward_imitate.NBTUtil_1_21_7;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, ItemStack stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)materials.getLeft());
        dogBedTileEntity.setBedding((IBeddingMaterial)materials.getRight());
    }

    public static ItemStack createRandomBed() {
        ICasingMaterial casing = DogBedMaterialManager.randomCasing();
        IBeddingMaterial bedding = DogBedMaterialManager.randomBedding();
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(ItemStack stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTagElement(stack, "doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = DogBedMaterialManager.getCasing(tag, "casingId");
            IBeddingMaterial beddingId = DogBedMaterialManager.getBedding(tag, "beddingId");
            return Pair.of((Object)casingId, (Object)beddingId);
        }
        return Pair.of((Object)DogBedMaterialManager.NaniCasing.NULL, (Object)DogBedMaterialManager.NaniBedding.NULL);
    }

    public static ItemStack createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        ItemStack stack = new ItemStack((ItemLike)DoggyBlocks.DOG_BED.get(), 1);
        CompoundTag tag = new CompoundTag();
        NBTUtil_1_21_7.putRegistryValue(tag, "casingId", DogBedMaterialManager.getKey(casingId));
        NBTUtil_1_21_7.putRegistryValue(tag, "beddingId", DogBedMaterialManager.getKey(beddingId));
        CompoundTag maintag = new CompoundTag();
        maintag.put("doggytalents", (Tag)tag);
        ItemUtil.putTag(stack, CompoundTag_1_21_5.wrap(maintag));
        return stack;
    }

    public static Optional<IBeddingMaterial> getBeddingFromStack(ItemStack stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getBedding);
    }

    public static Optional<ICasingMaterial> getCasingFromStack(ItemStack stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getCasing);
    }

    public static <T extends IDogBedMaterial> Optional<T> getBedMaterialFromStack(ItemStack stack, Function<ResourceLocation, T> bed_material_getter) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem block_item = (BlockItem)item;
        Block block = block_item.getBlock();
        if (block == null) {
            return Optional.empty();
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        IDogBedMaterial material = (IDogBedMaterial)bed_material_getter.apply(id);
        if (material.isNani()) {
            return Optional.empty();
        }
        return material.getIngredient().filter(ingredient -> ingredient.test(stack)).map(x -> material);
    }

    public static ItemStack createItemStackForced(Block casing, Block bedding) {
        ItemStack stack = new ItemStack((ItemLike)DoggyBlocks.DOG_BED.get(), 1);
        CompoundTag tag = new CompoundTag();
        NBTUtil_1_21_7.putRegistryValue(tag, "casingId", BuiltInRegistries.BLOCK.getKey((Object)casing));
        NBTUtil_1_21_7.putRegistryValue(tag, "beddingId", BuiltInRegistries.BLOCK.getKey((Object)bedding));
        CompoundTag maintag = new CompoundTag();
        maintag.put("doggytalents", (Tag)tag);
        ItemUtil.putTag(stack, CompoundTag_1_21_5.wrap(maintag));
        return stack;
    }
}

