/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class BedFinderRenderer {
    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        for (Entity passenger : player.getPassengers()) {
            Dog dog;
            Optional<BlockPos> bedPosOpt;
            if (!(passenger instanceof Dog) || !(bedPosOpt = (dog = (Dog)passenger).getBedPos()).isPresent()) continue;
            BlockPos bedPos = bedPosOpt.get();
            int level = dog.getDogLevel(DoggyTalents.BED_FINDER);
            double distance = (double)level * 200.0 - Math.sqrt(bedPos.distSqr((Vec3i)dog.blockPosition()));
            if (level != 5 && !(distance >= 0.0)) continue;
            PoseStack stack = event.getPoseStack();
            AABB boundingBox = new AABB(bedPos).inflate(0.5);
            BedFinderRenderer.drawSelectionBox(stack, boundingBox);
        }
    }

    public static void drawSelectionBox(PoseStack stack, AABB boundingBox) {
    }
}

