/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StatsView.view;

import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.common.entity.stats.StatsTracker;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.stats.StatFormatter;

public class StatsGeneralView
extends AbstractElement {
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;
    StatsTracker stats;
    Font font;

    public StatsGeneralView(AbstractElement parent, Screen screen, StatsTracker stats, Font font) {
        super(parent, screen);
        this.stats = stats;
        this.font = font;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int startX = this.getRealX() + 5;
        int pY = this.getRealY() + 5;
        String i18nPrefix = "doggui.stats.general.";
        String draw = I18n.get((String)(i18nPrefix + "damageDealt"), (Object[])new Object[0]) + ": " + this.formatHealth(this.stats.getDamageDealt()) + " ";
        graphics.drawString(this.font, draw, startX, pY, -1);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, startX + this.font.width(draw), pY - 1, 16, 0, 9, 9);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, startX + this.font.width(draw), pY - 1, 61, 0, 9, 9);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceInWater"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceInWater());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceOnWater"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceOnWater());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceRidden"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceRidden());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceSneaking"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceSneaking());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceSprinting"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceSprint());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        draw = I18n.get((String)(i18nPrefix + "distanceWalking"), (Object[])new Object[0]) + ": " + this.formatDistance(this.stats.getDistanceWalk());
        graphics.drawString(this.font, draw, startX, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        pY += 9 + 3;
    }

    private String formatDistance(int x_cm) {
        return StatFormatter.DISTANCE.format(x_cm);
    }

    private String formatHealth(float h) {
        return StatFormatter.DECIMAL_FORMAT.format(h);
    }
}

