/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.DoggyItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DTNDatapackProvider {
    public static void start(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        CompletableFuture prov = event.getLookupProvider();
        DataGenerator.PackGenerator pack_gen = gen.getBuiltinDatapack(event.includeServer(), "doggytalents", "alt_recipe_1");
        pack_gen.addProvider(pack_output -> PackMetadataGenerator.forFeaturePack((PackOutput)pack_output, (Component)Component.literal((String)"Make Conducting Bone Recipe less expensive.")));
        pack_gen.addProvider(pack_output -> PackRecipeProvider.of(pack_output, prov, (recipe_output, recipe_prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)DoggyItems.CONDUCTING_BONE.get()), (int)1).pattern(" D ").pattern("SBS").pattern(" T ").define(Character.valueOf('T'), (ItemLike)DoggyItems.TRAINING_TREAT.get()).define(Character.valueOf('S'), (ItemLike)Items.NETHERITE_SCRAP).define(Character.valueOf('B'), (ItemLike)Items.BONE).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).unlockedBy("has_netherite_scrap", recipe_prov.has((ItemLike)Items.NETHERITE_SCRAP)).save(recipe_output)));
    }

    public static class PackRecipeProvider
    extends RecipeProvider {
        private final PackRecipeBuilder recipeBuilder;

        private PackRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> prov, PackRecipeBuilder recipeBuilder) {
            super(output, prov);
            this.recipeBuilder = recipeBuilder;
        }

        public static PackRecipeProvider of(PackOutput output, CompletableFuture<HolderLookup.Provider> prov, PackRecipeBuilder recipeBuilder) {
            return new PackRecipeProvider(output, prov, recipeBuilder);
        }

        protected void buildRecipes(RecipeOutput output) {
            this.recipeBuilder.buildRecipes(output, new RecipeProviderAccessor(this){

                @Override
                public Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
                    return PackRecipeProvider.has((ItemLike)item);
                }
            });
        }

        @FunctionalInterface
        public static interface PackRecipeBuilder {
            public void buildRecipes(RecipeOutput var1, RecipeProviderAccessor var2);
        }

        public static interface RecipeProviderAccessor {
            public Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike var1);
        }
    }
}

