/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyItems;
import doggytalents.common.entity.misc.BaseDogPlushie;
import doggytalents.common.item.DogPlushieItem;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NetworkUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class DogPlushie
extends BaseDogPlushie
implements IEntityWithComplexSpawn {
    private int collarCollor = 11546150;
    private DogVariant variant = DogVariantUtil.getDefault();
    private boolean collarThicc = false;

    public DogPlushie(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void setCollarColor(int val) {
        this.collarCollor = val;
    }

    public int getCollarColor() {
        return this.collarCollor;
    }

    public void setDogVariant(DogVariant variant) {
        this.variant = variant;
    }

    public DogVariant getDogVariant() {
        return this.variant;
    }

    public void setCollarThicc(boolean val) {
        this.collarThicc = val;
    }

    public boolean getCollarThicc() {
        return this.collarThicc;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("PlushCollarColor", 3)) {
            this.setCollarColor(compound.getInt("PlushCollarColor"));
        }
        if (compound.contains("classicalVariant", 8)) {
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.getString("classicalVariant")));
        }
        this.setCollarThicc(compound.getBoolean("collarThicc"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("PlushCollarColor", this.getCollarColor());
        compound.putString("classicalVariant", DogVariantUtil.toSaveString(this.getDogVariant()));
        compound.putBoolean("collarThicc", this.getCollarThicc());
    }

    @Override
    public ItemStack getDogPlusieItemDrop() {
        DogPlushieItem item = DoggyItems.DOG_PLUSHIE_TOY.get();
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemUtil.setDyeColorForStack(stack, this.getCollarColor());
        return stack;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.getCollarColor());
        NetworkUtil.writeDogVariantToBuf((FriendlyByteBuf)buf, this.variant);
        buf.writeBoolean(this.getCollarThicc());
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        int collar_color = buf.readInt();
        DogVariant variant = NetworkUtil.readDogVariantFromBuf((FriendlyByteBuf)buf);
        boolean thicc = buf.readBoolean();
        this.setCollarColor(collar_color);
        this.setDogVariant(variant);
        this.setCollarThicc(thicc);
    }
}

