/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NBTUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ScentTreatItem
extends Item {
    public static String SCENT_BLOCK_ID = "DTN_scented_block_id";

    public ScentTreatItem(Item.Properties itemProps) {
        super(itemProps.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (this.handleClearScent(state, context).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleAddScent(state, context).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult handleClearScent(BlockState state, UseOnContext context) {
        if (!state.is(Blocks.WATER_CAULDRON)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.contains(SCENT_BLOCK_ID)) {
            return InteractionResult.PASS;
        }
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemUtil.clearTag(stack);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleAddScent(BlockState state, UseOnContext context) {
        if (state.is(Blocks.WATER_CAULDRON)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        CompoundTag tag = ItemUtil.getTag(stack);
        if (tag.contains(SCENT_BLOCK_ID)) {
            return InteractionResult.PASS;
        }
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Block block = state.getBlock();
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        NBTUtil.putResourceLocation(tag, SCENT_BLOCK_ID, id);
        ItemUtil.putTag(stack, tag);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId(stack) + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.contains(SCENT_BLOCK_ID)) {
            return;
        }
        Block block = (Block)NBTUtil.getRegistryValue(tag, SCENT_BLOCK_ID, BuiltInRegistries.BLOCK);
        if (block == null) {
            return;
        }
        components.add((Component)Component.translatable((String)(this.getDescriptionId() + ".scented_block")).withStyle(Style.EMPTY.withColor(-5586).withBold(Boolean.valueOf(true))));
        components.add((Component)Component.translatable((String)block.asItem().getDescriptionId()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(-9443221)));
    }
}

