/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogUntameData;
import doggytalents.common.util.ItemUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class DogUntamePacket
extends DogPacket<DogUntameData> {
    @Override
    public DogUntameData decode(FriendlyByteBuf buf) {
        return new DogUntameData(buf.readInt());
    }

    @Override
    public void handleDog(Dog dog, DogUntameData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.getMainHandItem();
        if (stack.getItem() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.getCooldowns().isOnCooldown(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.getUUID())) {
            return;
        }
        if (sender.experienceLevel < AmnesiaBoneItem.getUntameXPCost()) {
            return;
        }
        dog.untame();
        sender.giveExperienceLevels(-AmnesiaBoneItem.getUntameXPCost());
        dog.level().broadcastEntityEvent((Entity)dog, (byte)6);
        CompoundTag tag = ItemUtil.getTag(stack);
        int usedTime = tag.getInt("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.shrink(1);
            sender.onEquippedItemBroken(stack.getItem(), EquipmentSlot.MAINHAND);
        }
        tag.putInt("amnesia_bone_used_time", usedTime);
        sender.getCooldowns().addCooldown(DoggyItems.AMNESIA_BONE.get(), 60);
        ItemUtil.putTag(stack, tag);
    }
}

