/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.dog.DogPoseSetups;
import doggytalents.client.forward_imitate.ARGBUtil_1_20_under;
import doggytalents.client.forward_imitate.RenderUtil_1_20_under;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DogModel
extends EntityModel<Dog> {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public ModelPart root;
    public Optional<ModelPart> earLeft;
    public Optional<ModelPart> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;

    public DogModel(ModelPart box) {
        this.initDogModel(box);
    }

    public DogModel(ModelPart box, Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
        this.initDogModel(box);
    }

    protected void initDogModel(ModelPart box) {
        this.populateMandatoryParts(box);
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    private final void populateMandatoryParts(ModelPart box) {
        this.root = box;
        this.head = box.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = box.m_171324_("body");
        this.mane = box.m_171324_("upper_body");
        this.legBackRight = box.m_171324_("right_hind_leg");
        this.legBackLeft = box.m_171324_("left_hind_leg");
        this.legFrontRight = box.m_171324_("right_front_leg");
        this.legFrontLeft = box.m_171324_("left_front_leg");
        this.tail = box.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
    }

    protected void addOptionalParts(ModelPart box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<ModelPart> getChildIfPresent(ModelPart box, String name) {
        if (!box.m_233562_(name)) {
            return Optional.empty();
        }
        return Optional.of(box.m_171324_(name));
    }

    protected void correctInitalPose() {
        PartPose tailPose = this.tail.m_233566_();
        float tailX = tailPose.f_171405_;
        float tailY = tailPose.f_171406_;
        float tailZ = tailPose.f_171407_;
        this.tail.m_233560_(PartPose.m_171419_((float)tailX, (float)tailY, (float)tailZ));
    }

    public static LayerDefinition createBodyLayer() {
        return DogModel.createBodyLayerInternal(CubeDeformation.f_171458_);
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.m_171576_();
        float var2 = 13.5f;
        PartDefinition var3 = var1.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = var3.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).m_171514_(0, 10).m_171488_(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), PartPose.f_171404_);
        real_head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.m_171599_("right_hind_leg", var4, PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("left_hind_leg", var4, PartPose.m_171419_((float)1.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("right_front_leg", var4, PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.m_171599_("left_front_leg", var4, PartPose.m_171419_((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        boolean stand_pose;
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        boolean bl = stand_pose = !DogPoseSetups.setupPose(pose, this, dog, limbSwing, limbSwingAmount, partialTickTime);
        if (stand_pose) {
            this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = Mth.m_14089_((float)(limbSwing * 0.6662f));
        float w1 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = Mth.m_14036_((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.f_104203_ += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.f_104202_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.f_104203_ += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.f_104202_ += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().f_104203_ += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().f_104205_ += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().f_104203_ += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().f_104205_ += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.f_104203_ += w * 1.4f * limbSwingAmount;
        this.legBackLeft.f_104203_ += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.f_104203_ += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.f_104203_ += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = Mth.m_14205_((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.f_104205_ = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.f_104205_ = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.f_104205_ = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.f_104205_ = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = this.head.f_104204_ + netHeadYaw * (dog.m_21825_() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.f_104203_ = dog.getTailRotation();
            this.tail.f_104204_ = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.f_104203_;
            this.headYRot0 = this.head.f_104204_;
            this.realHeadZRot0 = this.realHead.f_104205_;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.f_104203_;
        }
        anim.rootRotation().ifPresent(x -> this.root.f_104204_ += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.m_171331_().forEach(x -> x.m_233569_());
        this.realHead.m_233569_();
        this.realTail.m_233569_();
        this.earLeft.ifPresent(ear -> ear.m_233569_());
        this.earRight.ifPresent(ear -> ear.m_233569_());
    }

    public void copyFrom(DogModel dogModel) {
        this.root.m_104315_(dogModel.root);
        this.head.m_104315_(dogModel.head);
        this.realHead.m_104315_(dogModel.realHead);
        this.body.m_104315_(dogModel.body);
        this.mane.m_104315_(dogModel.mane);
        this.legBackRight.m_104315_(dogModel.legBackRight);
        this.legBackLeft.m_104315_(dogModel.legBackLeft);
        this.legFrontRight.m_104315_(dogModel.legFrontRight);
        this.legFrontLeft.m_104315_(dogModel.legFrontLeft);
        this.tail.m_104315_(dogModel.tail);
        this.realTail.m_104315_(dogModel.realTail);
    }

    public void resetPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.m_233569_();
            this.tail.f_104203_ = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.m_233569_();
            this.head.f_104203_ = this.headXRot0;
            this.head.f_104204_ = this.headYRot0;
            this.realHead.m_233569_();
            this.realHead.f_104205_ = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.m_233569_();
            this.head.f_104203_ = this.headXRot0;
            return;
        }
        part.m_233569_();
    }

    public void adjustAnimatedPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.f_104203_ > 3.0f) {
            part.f_104203_ = 3.0f;
        }
        if (part == this.head && part.f_104205_ != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.f_104205_ = part.f_104205_;
            part.f_104205_ = 0.0f;
        }
    }

    public Optional<ModelPart> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.root, name);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean renderDogWetShade() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.f_104207_ = visible;
        this.body.f_104207_ = visible;
        this.legBackRight.f_104207_ = visible;
        this.legBackLeft.f_104207_ = visible;
        this.legFrontRight.f_104207_ = visible;
        this.legFrontLeft.f_104207_ = visible;
        this.tail.f_104207_ = visible;
        this.mane.f_104207_ = visible;
    }

    public void m_102624_(EntityModel<Dog> model) {
        super.m_102624_(model);
        if (!this.scaleBabyDog()) {
            model.f_102610_ = false;
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void m_7695_(PoseStack stack, VertexConsumer vertex_consumer, int light, int overlay, float r, float g, float b, float a) {
        int color_overlay = ARGBUtil_1_20_under.colorFromFloat(a, r, g, b);
        if (this.renderDogWetShade()) {
            int wet_color = ARGBUtil_1_20_under.colorFromFloat(1.0f, this.wetShade, this.wetShade, this.wetShade);
            color_overlay = FastColor.ARGB32.m_13657_((int)color_overlay, (int)wet_color);
        }
        DogModelRenderContext ctx = DogModelRenderContext.forDogModelRendering(this, vertex_consumer, light, overlay, color_overlay, this.getDogModelAdditionalHeadRenderer());
        DogModel.renderDogModelFromRootWithPivot(stack, ctx);
    }

    protected Optional<AddtionalHeadRenderer> getDogModelAdditionalHeadRenderer() {
        return Optional.empty();
    }

    private Optional<ModelPart> getDogModelBabyHead() {
        return this.doScaleBabyHead() ? Optional.of(this.head) : Optional.empty();
    }

    protected boolean doScaleBabyHead() {
        return this.f_102610_ && this.scaleBabyDog();
    }

    public static void renderDogModelFromRootWithPivot(PoseStack stack, DogModelRenderContext ctx) {
        ModelPart root = ctx.root();
        Vector3f pivot = ctx.pivot();
        Optional<ModelPart> head_baby = ctx.headBaby();
        DogRenderPartContext part_ctx = ctx.renderPartContext().orElse(null);
        AddtionalHeadRenderer addtional_head = ctx.additionalHeadRenderer().orElse(null);
        stack.m_85836_();
        DogModel.applyRootTransformWithPivotedRotation(root, stack, pivot);
        RootRotationTranslationStash stashed_root = RootRotationTranslationStash.stash(root);
        if (head_baby.isPresent()) {
            ModelPart head = head_baby.get();
            boolean headVisible0 = head.f_104207_;
            head.f_104207_ = false;
            stack.m_85836_();
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            stack.m_85849_();
            head.f_104207_ = headVisible0;
            stack.m_85836_();
            stack.m_85841_(2.0f, 2.0f, 2.0f);
            stack.m_85837_(0.0, -0.5, 0.15);
            if (part_ctx != null) {
                part_ctx.renderPart(stack, head);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
            stack.m_85849_();
        } else {
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
        }
        stack.m_85849_();
        stashed_root.restore(root);
    }

    private static void applyRootTransformWithPivotedRotation(ModelPart root, PoseStack stack, Vector3f pivot) {
        stack.m_252880_(root.f_104200_ / 16.0f, root.f_104201_ / 16.0f, root.f_104202_ / 16.0f);
        stack.m_252880_(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
        if (root.f_104203_ != 0.0f || root.f_104204_ != 0.0f || root.f_104205_ != 0.0f) {
            stack.m_252781_(new Quaternionf().rotationZYX(root.f_104205_, root.f_104204_, root.f_104203_));
        }
        stack.m_252880_(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED,
        MODEL_ONLY;

    }

    public record DogModelRenderContext(ModelPart root, Vector3f pivot, Optional<ModelPart> headBaby, Optional<DogRenderPartContext> renderPartContext, Optional<AddtionalHeadRenderer> additionalHeadRenderer) {
        public static DogModelRenderContext forDogModelRendering(DogModel model, VertexConsumer vertex_consumer, int light, int overlay, int color_overlay, Optional<AddtionalHeadRenderer> addtionalHeadRenderer) {
            Vector3f pivot = DEFAULT_ROOT_PIVOT;
            Vector3f custom_pivot = model.getCustomRootPivotPoint();
            if (custom_pivot != null) {
                pivot = custom_pivot;
            }
            DogRenderPartContext render_part_ctx = new DogRenderPartContext(vertex_consumer, light, overlay, color_overlay);
            return new DogModelRenderContext(model.root, pivot, model.getDogModelBabyHead(), Optional.of(render_part_ctx), addtionalHeadRenderer);
        }
    }

    public record DogRenderPartContext(VertexConsumer vertex_consumer, int light, int overlay, int color_overlay) {
        public void renderPart(PoseStack stack, ModelPart part) {
            RenderUtil_1_20_under.renderPart(part, stack, this.vertex_consumer(), this.light(), this.overlay(), this.color_overlay());
        }

        public void renderGlowingPart(PoseStack stack, ModelPart part) {
            RenderUtil_1_20_under.renderPart(part, stack, this.vertex_consumer(), 0xF000F0, this.overlay(), this.color_overlay());
        }
    }

    @FunctionalInterface
    public static interface AddtionalHeadRenderer {
        public void render(PoseStack var1, Optional<DogRenderPartContext> var2);
    }

    private record RootRotationTranslationStash(float x, float y, float z, float xRot, float yRot, float zRot) {
        public static RootRotationTranslationStash stash(ModelPart root) {
            RootRotationTranslationStash ret = new RootRotationTranslationStash(root.f_104200_, root.f_104201_, root.f_104202_, root.f_104203_, root.f_104204_, root.f_104205_);
            root.f_104200_ = 0.0f;
            root.f_104201_ = 0.0f;
            root.f_104202_ = 0.0f;
            root.f_104203_ = 0.0f;
            root.f_104204_ = 0.0f;
            root.f_104205_ = 0.0f;
            return ret;
        }

        public void restore(ModelPart root) {
            root.f_104200_ = this.x;
            root.f_104201_ = this.y;
            root.f_104202_ = this.z;
            root.f_104203_ = this.xRot;
            root.f_104204_ = this.yRot;
            root.f_104205_ = this.zRot;
        }
    }
}

