/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.entity.skin.DogSkinHolder;
import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.DogStatusViewBoxElement;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveSkinSlice;
import doggytalents.client.screen.DogNewInfoScreen.widget.AccessoryStatusHover;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.DivElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ScrollView;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class DogSkinElement
extends AbstractElement {
    private static int LINE_SPACING = 2;
    Dog dog;
    List<DogSkin> locList;
    final Dog dummyDog;
    int activeSkinId;
    Font font;
    boolean showInfo;
    private TextOnlyButton copy_sha1_button;

    public DogSkinElement(AbstractElement parent, Screen screen, Dog dog, Dog dummy, List<DogSkin> locList, int active_id) {
        super(parent, screen);
        this.dog = dog;
        this.locList = locList;
        this.activeSkinId = active_id;
        this.font = Minecraft.m_91087_().f_91062_;
        this.dummyDog = dummy;
    }

    @Override
    public AbstractElement init() {
        if (this.locList.isEmpty()) {
            return this;
        }
        if (this.activeSkinId < 0) {
            return this;
        }
        if (this.activeSkinId >= this.locList.size()) {
            return this;
        }
        this.addAccStateHover();
        this.showInfo = this.getStateAndSubscribesTo(ActiveSkinSlice.class, ActiveSkinSlice.class, new ActiveSkinSlice()).showInfo;
        if (!this.showInfo) {
            return this;
        }
        DogSkin manifestSkin = this.locList.get(this.activeSkinId);
        if (!manifestSkin.hasExtraInfo()) {
            return this;
        }
        ScrollView scrollView = new ScrollView(this, this.getScreen());
        scrollView.setPosition(ElementPosition.PosType.ABSOLUTE, Mth.m_14143_((float)((float)this.getParent().getSizeX() * 0.45f)), 0).setSize(0.55f, 1.0f).init();
        this.addChildren((GuiEventListener)scrollView);
        AbstractElement scroll = scrollView.getContainer();
        scroll.addChildren((GuiEventListener)new DivElement(scroll, this.getScreen()).setSize(1.0f, Math.max(10, this.getSizeY() / 2 - 40)).init());
        if (!manifestSkin.getName().isEmpty()) {
            scroll.addChildren((GuiEventListener)new SkinStrEntry(scroll, this.getScreen(), (Component)Component.m_237113_((String)"Name: "), (Component)Component.m_237113_((String)manifestSkin.getName())).init());
        }
        if (!manifestSkin.getBasedOn().isEmpty()) {
            scroll.addChildren((GuiEventListener)new SkinStrEntry(scroll, this.getScreen(), (Component)Component.m_237113_((String)"Based On: "), (Component)Component.m_237113_((String)manifestSkin.getBasedOn())).init());
        }
        if (!manifestSkin.getAuthor().isEmpty()) {
            scroll.addChildren((GuiEventListener)new SkinStrEntry(scroll, this.getScreen(), (Component)Component.m_237113_((String)"Author: "), (Component)Component.m_237113_((String)manifestSkin.getAuthor())).init());
        }
        if (!manifestSkin.getDesc().isEmpty()) {
            scroll.addChildren((GuiEventListener)new SkinStrEntry(scroll, this.getScreen(), (Component)Component.m_237113_((String)"Desciption: "), (Component)Component.m_237113_((String)manifestSkin.getDesc())).init());
        }
        if (!manifestSkin.getTags().isEmpty()) {
            scroll.addChildren((GuiEventListener)new SkinStrEntry(scroll, this.getScreen(), (Component)Component.m_237113_((String)"Tags: "), (Component)Component.m_237113_((String)manifestSkin.getTags())).init());
        }
        if (manifestSkin.isCustom()) {
            this.initSha1Button();
            scroll.addChildren((GuiEventListener)new DivElement(scroll, this.getScreen()){

                @Override
                public AbstractElement init() {
                    this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
                    this.setSize(1.0f, 20);
                    TextOnlyButton button = DogSkinElement.this.copy_sha1_button;
                    Objects.requireNonNull(DogSkinElement.this.font);
                    button.setHeight(9 + 5);
                    button.m_252865_(this.getRealX() + 10);
                    button.m_253211_(this.getRealY() + this.getSizeY() - button.m_93694_());
                    this.addChildren((GuiEventListener)button);
                    return super.init();
                }
            }.init());
        }
        return this;
    }

    private void addAccStateHover() {
        DogSkin skin = this.locList.get(this.activeSkinId);
        DogModel.AccessoryState state = this.getStateFromSkin(skin);
        AccessoryStatusHover button = new AccessoryStatusHover(0, 0, state);
        button.m_252865_(this.getRealX() + 6);
        button.m_253211_(this.getRealY() + this.getSizeY() - 25);
        this.addChildren((GuiEventListener)button);
    }

    private DogModel.AccessoryState getStateFromSkin(DogSkin skin) {
        if (!skin.useCustomModel()) {
            return DogModel.AccessoryState.RECOMMENDED;
        }
        DogModelRegistry.DogModelHolder model = skin.getCustomModel();
        return model.getValue().getAccessoryState();
    }

    private void copySha1() {
        DogSkin skin = this.locList.get(this.activeSkinId);
        if (!skin.isCustom()) {
            return;
        }
        String sha1 = DogTextureManager.INSTANCE.getHash(skin);
        if (sha1 == null || sha1.isEmpty()) {
            return;
        }
        Minecraft.m_91087_().f_91068_.m_90911_(sha1);
    }

    private void initSha1Button() {
        MutableComponent sha1_txt = Component.m_237113_((String)"Copy SHA-1").m_130948_(Style.f_131099_.m_178520_(0x696868));
        this.copy_sha1_button = new TextOnlyButton(0, 0, this.font.m_92852_((FormattedText)sha1_txt), 10, (Component)sha1_txt, b -> {
            this.copySha1();
            b.m_93666_((Component)Component.m_237113_((String)"SHA-1 Copied!").m_130948_(Style.f_131099_.m_178520_(-14702592)));
        }, this.font);
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.locList == null) {
            return;
        }
        if (this.locList.isEmpty()) {
            return;
        }
        if (this.activeSkinId < 0) {
            return;
        }
        if (this.activeSkinId >= this.locList.size()) {
            return;
        }
        if (this.showInfo) {
            this.renderShowInfo(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.renderNonShowInfo(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderNonShowInfo(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        int e_mX = this.getRealX() + mX;
        int e_mY = this.getRealY() + mY - 10;
        int maxLen = this.getSizeX() - 120;
        Object nameStr = this.locList.get(this.activeSkinId).getName();
        int nameStrLen = this.font.m_92895_((String)nameStr);
        if (nameStrLen > maxLen) {
            int cutLen = Math.max(0, maxLen - this.font.m_92895_(".."));
            nameStr = this.font.m_92834_((String)nameStr, cutLen) + "..";
        }
        MutableComponent c1 = Component.m_237113_((String)nameStr);
        c1.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        int nameX = this.getRealX() + mX - this.font.m_92852_((FormattedText)c1) / 2;
        int nameY = this.getRealY() + this.getSizeY() - 13;
        graphics.m_280430_(this.font, (Component)c1, nameX, nameY, -1);
        int prevId = this.activeSkinId - 1;
        int nextId = this.activeSkinId + 1;
        if (nextId < this.locList.size()) {
            this.renderSkinAndDogModel(nextId, false, graphics, mouseX, mouseY, e_mX + 32 + 25 + 25, e_mY + 32, 50, true);
        }
        if (prevId >= 0) {
            this.renderSkinAndDogModel(prevId, false, graphics, mouseX, mouseY, e_mX - 32 - 25 - 25, e_mY + 32, 50, true);
        }
        this.renderSkinAndDogModel(this.activeSkinId, true, graphics, mouseX, mouseY, e_mX, e_mY + 36, 64, false);
    }

    private void renderShowInfo(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        int e_mX = this.getRealX() + mX;
        int e_mY = this.getRealY() + mY - 10;
        this.renderSkinAndDogModel(this.activeSkinId, true, graphics, mouseX, mouseY, this.getRealX() + 70, e_mY + 36, 64, true);
        DogSkin manifestSkin = this.locList.get(this.activeSkinId);
        if (!manifestSkin.hasExtraInfo()) {
            this.renderNoInfo(graphics, mouseX, mouseY, partialTicks);
            return;
        }
    }

    private void renderNoInfo(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        MutableComponent c1 = Component.m_237113_((String)"No info to show.");
        int tX = this.getRealX() + mX - 10;
        int n = this.getRealY() + mY;
        Objects.requireNonNull(this.font);
        int tY = n - 9 / 2;
        graphics.m_280430_(this.font, (Component)c1, tX, tY, -1);
    }

    private void renderSkinAndDogModel(int indx, boolean followMouse, GuiGraphics graphics, int mouseX, int mouseY, int e_mX, int e_mY, int size, boolean useDummy) {
        DogSkinHolder oldSkin = this.dog.getClientSkinHolder();
        DogSkin manifestSkin = this.locList.get(indx);
        if (manifestSkin.mystery()) {
            manifestSkin = DogSkin.MYSTERY;
            this.renderMysteriousKanji(graphics, e_mX, e_mY);
            this.dummyDog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dummyDog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
        } else if (useDummy && this.dummyDog != null) {
            this.dummyDog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dummyDog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
        } else {
            this.dog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
            this.dog.setClientSkinHolder(oldSkin);
        }
        if (oldSkin.getOrElse(DogSkin.CLASSICAL) == manifestSkin) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent c1 = Component.m_237115_((String)"doggui.style.skins.selected");
            c1.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(-14702592));
            int c1_len = font.m_92852_((FormattedText)c1);
            int tX = e_mX - c1_len / 2;
            int tY = e_mY + 28;
            graphics.m_280430_(font, (Component)c1, tX, tY, -1);
        }
    }

    private void renderMysteriousKanji(GuiGraphics graphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 100;
        graphics.m_280398_(Resources.KANJI_MYSTERY_BKG, x - imgeSize / 2, y - imgeSize / 2 - 27, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280398_(Resources.KANJI_MYSTERY, x - imgeSize / 2, y - imgeSize / 2 - 27, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        stack.m_85849_();
        RenderSystem.disableBlend();
    }

    public static class SkinStrEntry
    extends AbstractElement {
        private Component title;
        private Component content;
        private List<FormattedCharSequence> components;
        private Font font;

        public SkinStrEntry(AbstractElement parent, Screen screen, Component title, Component content) {
            super(parent, screen);
            this.title = title;
            this.content = content;
            this.font = Minecraft.m_91087_().f_91062_;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.title = this.title.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            this.components = this.font.m_92923_((FormattedText)this.content, this.getParent().getSizeX() - 20);
            Objects.requireNonNull(this.font);
            int n = this.components.size();
            Objects.requireNonNull(this.font);
            int totalH = LINE_SPACING + 9 + LINE_SPACING + n * (LINE_SPACING + 9) + LINE_SPACING;
            this.setSize(1.0f, totalH);
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int pX = this.getRealX();
            int pY = this.getRealY() + LINE_SPACING;
            graphics.m_280430_(this.font, this.title, pX, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + LINE_SPACING;
            for (FormattedCharSequence line : this.components) {
                graphics.m_280648_(this.font, line, pX, pY, -1);
                Objects.requireNonNull(this.font);
                pY += 9 + LINE_SPACING;
            }
        }
    }
}

