/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import doggytalents.client.entity.render.RenderUtil;
import doggytalents.common.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class FlatCheckbox
extends AbstractButton {
    private static final int DEFAULT_COLOR = 0x5E5D5D;
    private static final int DEFAULT_ACTIVE_COLOR = 7667877;
    private static final int HOVER_MASK = -2097152000;
    private static final int NON_HOVER_MASK = 0x48000000;
    private Font font;
    protected final OnChange onPress;
    private boolean value = false;
    private int activeColor;
    private float animTimeline = 0.0f;
    private long millis0 = 0L;

    public FlatCheckbox(int x, int y, int activeColor, OnChange onPress) {
        super(x, y, 28, 14, (Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.onPress = onPress;
        this.activeColor = activeColor;
        this.millis0 = System.currentTimeMillis();
    }

    public FlatCheckbox(int x, int y, OnChange onPress) {
        this(x, y, 7667877, onPress);
    }

    public void m_5691_() {
        this.onPress.onChange(this);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.f_93623_) {
            this.animTimeline = 0.0f;
            return;
        }
        this.updateAnim();
        int bg_color = this.maskColorHovered(this.colorLerp(0x5E5D5D, this.activeColor, this.animTimeline));
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bg_color);
        int nob_spacing = 2;
        int nob_size = this.m_93694_() - 4;
        int nob_x = this.getNobX(2, nob_size);
        int nob_y = this.m_252907_() + 2;
        if (this.value) {
            graphics.m_280509_(nob_x, nob_y, nob_x + nob_size, nob_y + nob_size, -1);
        } else {
            graphics.m_280509_(nob_x, nob_y, nob_x + nob_size, nob_y + nob_size, -1);
        }
    }

    private void updateAnim() {
        long current_millis = System.currentTimeMillis();
        long passed_millis = current_millis - this.millis0;
        if (passed_millis <= 0L) {
            return;
        }
        this.millis0 = current_millis;
        float anim_amount = (float)passed_millis / (float)this.getAnimMillis();
        this.animTimeline += this.value ? anim_amount : -anim_amount;
        this.animTimeline = Mth.m_14036_((float)this.animTimeline, (float)0.0f, (float)1.0f);
    }

    private int getNobX(int nob_spacing, int nob_size) {
        int nobX_true = this.m_252754_() + this.m_5711_() - nob_spacing - nob_size;
        int nobX_false = this.m_252754_() + nob_spacing;
        if (nobX_false > nobX_true) {
            int sw = nobX_true;
            nobX_true = nobX_false;
            nobX_false = sw;
        }
        int ret = (int)Mth.m_14179_((float)this.animTimeline, (float)nobX_false, (float)nobX_true);
        return Mth.m_14045_((int)ret, (int)nobX_false, (int)nobX_true);
    }

    private int colorLerp(int from_color, int to_color, float progress) {
        int[] acolor0 = Util.rgbIntToIntArray(from_color);
        int[] acolor1 = Util.rgbIntToIntArray(to_color);
        int red = (int)Mth.m_14036_((float)((float)acolor0[0] + (float)(acolor1[0] - acolor0[0]) * progress), (float)0.0f, (float)255.0f);
        int green = (int)Mth.m_14036_((float)((float)acolor0[1] + (float)(acolor1[1] - acolor0[1]) * progress), (float)0.0f, (float)255.0f);
        int blue = (int)Mth.m_14036_((float)((float)acolor0[2] + (float)(acolor1[2] - acolor0[2]) * progress), (float)0.0f, (float)255.0f);
        return RenderUtil.rgbToInt(new int[]{red, green, blue});
    }

    private int maskColorHovered(int color) {
        if (this.f_93622_) {
            return color | 0x83000000;
        }
        return color | 0x48000000;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public FlatCheckbox initialValue(boolean value) {
        this.value = value;
        this.animTimeline = value ? 1.0f : 0.0f;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    private int getAnimMillis() {
        return 30;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public static interface OnChange {
        public void onChange(FlatCheckbox var1);
    }
}

