/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.network.PacketDistributor;

public class DogInventoryButton
extends AbstractButton {
    private Screen parent;
    private int baseX;
    private boolean openSingle = false;
    private Optional<Dog> openSingleDog = Optional.empty();
    private Font font;
    private final Tooltip TOOLTIP_ACTIVE = Tooltip.m_257550_((Component)Component.m_237115_((String)"container.doggytalents.dog_inventories.link"));
    private final Tooltip TOOLTIP_NO_ACTIVE = Tooltip.m_257550_((Component)Component.m_237115_((String)"container.doggytalents.dog_inventories.link").m_130940_(ChatFormatting.RED));
    private static DogInventoryButton inventoryButton;

    public DogInventoryButton(int x, int y, Screen parentIn) {
        super(x, y, 13, 10, (Component)Component.m_237113_((String)""));
        this.baseX = x;
        this.parent = parentIn;
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public DogInventoryButton(int x, int y, Screen parentIn, Dog dog) {
        super(x, y, 13, 10, (Component)Component.m_237113_((String)""));
        this.baseX = x;
        this.parent = parentIn;
        this.openSingleDog = Optional.of(dog);
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen cscreen = (CreativeModeInventoryScreen)this.parent;
            this.f_93623_ = this.f_93624_ = cscreen.m_258017_();
        }
        if (this.parent instanceof InventoryScreen) {
            RecipeBookComponent recipeBook = ((InventoryScreen)this.parent).m_5564_();
            if (recipeBook.m_100385_()) {
                this.m_252865_(this.baseX + 77);
            } else {
                this.m_252865_(this.baseX);
            }
        }
        if (this.f_93624_) {
            Minecraft mc = Minecraft.m_91087_();
            List dogs = mc.f_91073_.m_6443_(Dog.class, mc.f_91074_.m_20191_().m_82377_(12.0, 12.0, 12.0), dog -> dog.canInteract((LivingEntity)mc.f_91074_) && PackPuppyTalent.hasInventory(dog));
            boolean bl = this.f_93623_ = !dogs.isEmpty();
            if (this.f_93623_) {
                this.m_257544_(this.TOOLTIP_ACTIVE);
            } else {
                this.m_257544_(this.TOOLTIP_NO_ACTIVE);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        Minecraft mc = Minecraft.m_91087_();
        int i = this.m_274533_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.m_280218_(Resources.SMALL_WIDGETS, this.m_252754_(), this.m_252907_(), 0, 36 + i * 10, this.f_93618_, this.f_93619_);
        if (this.openSingle) {
            int tX = this.m_252754_() + 11;
            int tY = this.m_252907_() + 5;
            graphics.m_280488_(this.font, "x1", tX, tY, -1);
        }
    }

    private int m_274533_() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return i;
    }

    public void m_5691_() {
        AbstractContainerScreen container;
        AbstractContainerMenu menu;
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen && (menu = (container = (AbstractContainerScreen)screen).m_6262_()) != null) {
            menu.m_142503_(ItemStack.f_41583_);
        }
        if (this.openSingle && this.openSingleDog.isPresent()) {
            Dog dog = this.openSingleDog.get();
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData(OpenDogScreenData.ScreenType.INVENTORY_SINGLE, dog.m_19879_()));
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData());
        }
        this.f_93623_ = false;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void keyGlobalPressed(int keyCode, int scanCode, int modifier) {
        Minecraft mc = Minecraft.m_91087_();
        KeyMapping shiftKey = mc.f_91066_.f_92090_;
        if (shiftKey.getKey().m_84873_() == keyCode && this.openSingleDog.isPresent()) {
            this.openSingle = true;
        }
    }

    public void keyGlobalReleased(int keyCode, int scanCode, int modifier) {
        this.openSingle = false;
    }

    public static void onScreenInit(ScreenEvent.Init.Post event) {
        boolean is_survival;
        Screen screen = event.getScreen();
        boolean bl = is_survival = screen != null && screen.getClass() == InventoryScreen.class;
        if (!is_survival) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.DOG_INV_BUTTON_IN_INV.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screen_w = mc.m_91268_().m_85445_();
        int screen_h = mc.m_91268_().m_85446_();
        int inv_w = 176;
        int inv_h = 166;
        int inv_x = (screen_w - inv_w) / 2;
        int inv_y = (screen_h - inv_h) / 2;
        int button_x_offset = (Integer)ConfigHandler.CLIENT.DOG_INV_IN_INV_BUTTON_X.get();
        int button_y_offset = (Integer)ConfigHandler.CLIENT.DOG_INV_IN_INV_BUTTON_Y.get();
        int button_x = inv_x + button_x_offset;
        int button_y = inv_y + button_y_offset;
        inventoryButton = new DogInventoryButton(button_x, button_y, screen);
        event.addListener((GuiEventListener)inventoryButton);
    }

    public static void onScreenRenderForeground(ScreenEvent.Render.Post event) {
    }
}

