/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogMode;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogBounceAction;
import doggytalents.common.entity.ai.triggerable.DogFaintStandAction;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class DogIncapacitatedMananger {
    private final Dog dog;
    private int recoveryMultiplier = 1;
    private static final UUID INCAP_MOVEMENT = UUID.fromString("9576c796-c7c7-4995-90d5-f60eafc58805");
    private boolean appliedIncapChanges = false;
    private static final int MAX_BANDAID_COUNT = 8;
    private float partialRecoverVal = 0.0f;
    private int bandagesCount = 0;
    private int bandageCooldown = 0;
    private int drownPoseTick = 0;
    private BlockState atBlockState = null;
    public static final int MAX_INCAP_MSG_LEN = 256;
    private String incapMsg = "";

    public DogIncapacitatedMananger(Dog dog) {
        this.dog = dog;
    }

    public void onModeUpdate(DogMode mode) {
        if (mode != DogMode.INJURED && this.appliedIncapChanges) {
            this.appliedIncapChanges = false;
            this.onExitingIncapMode();
        } else if (mode == DogMode.INJURED && !this.appliedIncapChanges) {
            this.appliedIncapChanges = true;
            this.onEnteringIncapMode();
        }
    }

    private void onEnteringIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.setAttributeModifier(Attributes.f_22279_, INCAP_MOVEMENT, (d, u) -> new AttributeModifier(u, "Defeated Slowness", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.dog.setDrunkTicks(0);
    }

    private void onExitingIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.removeAttributeModifier(Attributes.f_22279_, INCAP_MOVEMENT);
        this.incapMsg = "";
    }

    public void tick() {
        if (this.dog.m_9236_().f_46443_) {
            this.incapacitatedClientTick();
        } else {
            this.incapacitatedTick();
        }
    }

    public InteractionResult interact(ItemStack stack, Player player, InteractionHand hand) {
        if (this.proccessBandage(stack, player).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        Item item = stack.m_41720_();
        if (item == Items.f_42747_) {
            this.useTotem(stack, player);
            return InteractionResult.SUCCESS;
        }
        if (this.handleOwnerRide(stack, player).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.proccessSitStandOrder(player).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.dog.m_9236_().f_46443_ && player == this.dog.m_269323_()) {
            DogCannotInteractWithScreen.open(this.dog);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult proccessBandage(ItemStack stack, Player player) {
        boolean isBandage;
        boolean wagyu = this.needWagyu();
        boolean bl = isBandage = wagyu && stack.m_41720_() == DoggyItems.GOLDEN_A_FIVE_WAGYU.get() || !wagyu && stack.m_41720_() == DoggyItems.BANDAID.get();
        if (isBandage) {
            this.useBandage(stack, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void useBandage(ItemStack stack, Player player) {
        if (this.dog.m_9236_().f_46443_) {
            return;
        }
        if ((float)this.bandageCooldown > 0.0f) {
            return;
        }
        if (this.bandagesCount >= 8) {
            return;
        }
        this.bandageCooldown = 10;
        player.m_36335_().m_41524_(stack.m_41720_(), 11);
        ++this.bandagesCount;
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (this.bandagesCount >= 8) {
            this.dog.triggerAnimationAction(new DogFaintStandAction(this.dog, this.getFaintStandAnim()));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            DoggyAdvancementTriggers.DOG_BANDAID_APPLY_TRIGGER.trigger(this.dog, sP);
        }
    }

    private void useTotem(ItemStack stack, Player player) {
        if (this.dog.m_9236_().f_46443_) {
            return;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        List<Dog> defeatedDogs = DogUtil.getOtherIncapacitatedDogNearby(this.dog);
        for (Dog d : defeatedDogs) {
            d.setDogIncapValue(0);
            d.incapacitatedMananger.incapacitatedExit();
            d.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            d.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            d.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
        }
        this.dog.m_9236_().m_7605_((Entity)this.dog, (byte)35);
    }

    private InteractionResult handleOwnerRide(ItemStack stack, Player player) {
        if (player.m_20363_((Entity)this.dog)) {
            if (!this.dog.m_9236_().f_46443_) {
                this.dog.m_19877_();
            }
            return InteractionResult.SUCCESS;
        }
        Item item = stack.m_41720_();
        if (item != Items.f_42500_) {
            return InteractionResult.PASS;
        }
        if (this.dog.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (this.dog.m_269323_() != player) {
            return InteractionResult.PASS;
        }
        if (!this.dog.m_9236_().f_46443_ && this.dog.m_20329_((Entity)player)) {
            player.m_5661_((Component)Component.m_237110_((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.dog.getGenderPronoun()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult proccessSitStandOrder(Player player) {
        if (!this.canMove()) {
            return InteractionResult.PASS;
        }
        UUID owner_uuid = this.dog.m_21805_();
        if (owner_uuid == null) {
            return InteractionResult.PASS;
        }
        if (!owner_uuid.equals(player.m_20148_())) {
            return InteractionResult.PASS;
        }
        this.dog.m_21839_(!this.dog.m_21827_());
        this.dog.m_21573_().m_26573_();
        return InteractionResult.SUCCESS;
    }

    public void onHurt() {
        if (((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue()) {
            this.dropBandages();
            int currentIncapVal = this.dog.getDogIncapValue();
            if (currentIncapVal < this.dog.getDefaultInitIncapVal()) {
                this.dog.setDogIncapValue(this.dog.getDefaultInitIncapVal());
            }
        }
    }

    private void dropBandages() {
        if (this.needWagyu()) {
            return;
        }
        float keep_precentage = 0.8f - (float)this.dog.m_217043_().m_188503_(4) * 0.1f;
        int keep_amount = Mth.m_14143_((float)(keep_precentage * (float)this.bandagesCount));
        for (int i = 0; i < keep_amount; ++i) {
            Containers.m_18992_((Level)this.dog.m_9236_(), (double)this.dog.m_20185_(), (double)this.dog.m_20186_(), (double)this.dog.m_20189_(), (ItemStack)new ItemStack((ItemLike)DoggyItems.BANDAID.get(), 1));
        }
        this.bandageCooldown = 200;
        this.bandagesCount = 0;
        IncapacitatedSyncState incap_state = this.dog.getIncapSyncState();
        IncapacitatedSyncState new_incap_state = incap_state.updateBandaid(this.bandagesCount);
        if (new_incap_state != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
    }

    private void displayToastIncapacitated(Player player) {
        player.m_5661_((Component)Component.m_237115_((String)"doggui.invalid_dog.incapacitated.title").m_130940_(ChatFormatting.RED), true);
    }

    public void incapacitatedClientTick() {
        this.drownPoseTick = this.isDogDeepInFluid() ? ++this.drownPoseTick : 0;
        if (this.dog.isDogVariantRenderEffective() && this.dog.dogVariant().customInjuredTexture().isPresent()) {
            return;
        }
        IncapacitatedSyncState sync_state = this.dog.getIncapSyncState();
        DefeatedType type = sync_state.type;
        switch (type) {
            case BURN: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    this.dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + 0.4, this.dog.m_20189_() + (double)f2, 0.0, -0.05, 0.0);
                }
                if (this.dog.m_217043_().m_188503_(3) != 0) break;
                float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.5f;
                float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.5f;
                this.dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + (double)this.dog.m_20192_(), this.dog.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
                break;
            }
            case BLOOD: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.f_19797_ % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    this.dog.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42588_)), this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + 0.4, this.dog.m_20189_() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
            case DROWN: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.f_19797_ % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    this.dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + 0.4, this.dog.m_20189_() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
        }
    }

    public void incapacitatedTick() {
        IncapacitatedSyncState incap_state;
        IncapacitatedSyncState new_incap_state;
        if (this.dog.getDogIncapValue() <= 0) {
            this.incapacitatedExit();
            return;
        }
        if (this.partialRecoverVal >= 1.0f) {
            this.dog.setDogIncapValue(this.dog.getDogIncapValue() - 1);
            this.partialRecoverVal = 0.0f;
        }
        if (this.bandageCooldown > 0) {
            --this.bandageCooldown;
        }
        if ((new_incap_state = (incap_state = this.dog.getIncapSyncState()).updateBandaid(this.bandagesCount)) != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
        if (!((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue() && this.bandagesCount > 0 && this.isConditionDestroyBandages(this.dog)) {
            this.dropBandages();
            return;
        }
        this.healWithBandaid(new_incap_state.bandaid);
        LivingEntity owner = this.dog.m_269323_();
        BlockState dog_b0_state = this.dog.m_9236_().m_8055_(this.dog.m_20183_());
        Block dog_b0_block = dog_b0_state.m_60734_();
        if (dog_b0_block == Blocks.f_50016_) {
            this.partialRecoverVal += 0.001f * (float)this.recoveryMultiplier;
        } else if (dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.m_204336_(BlockTags.f_13038_)) {
            this.incapacitatedHealWithBed(owner);
        }
    }

    private boolean isConditionDestroyBandages(Dog dog) {
        if (!dog.m_5825_() && dog.m_6060_()) {
            return true;
        }
        if (!dog.canSwimUnderwater() && dog.m_20069_()) {
            return true;
        }
        return !dog.dogFallImmune() && dog.f_19789_ > 3.0f;
    }

    private void incapacitatedExit() {
        int bandaid_count0 = this.bandagesCount;
        this.dog.maxHealth();
        this.dog.setMode(DogMode.DOCILE);
        this.dog.setDogHunger(this.dog.getMaxHunger());
        this.dog.setDogIncapValue(0);
        this.dog.m_21839_(true);
        this.dog.setIncapSyncState(IncapacitatedSyncState.NONE);
        this.dog.triggerAnimationAction(new DogBounceAction(this.dog));
        this.dog.m_21219_();
        Level level = this.dog.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            sL.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 24, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
        }
        if (bandaid_count0 > 0) {
            LivingEntity owner = this.dog.m_269323_();
            this.triggerAdvancement(owner, bandaid_count0);
        }
    }

    private void triggerAdvancement(LivingEntity player, int bandages_count0) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sP = (ServerPlayer)player;
        DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, false);
        if (this.isBestRecoveryCondition(bandages_count0)) {
            DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, true);
        }
    }

    private boolean isBestRecoveryCondition(int bandaid_count0) {
        if (bandaid_count0 < 8) {
            return false;
        }
        BlockState dog_b0_state = this.dog.m_9236_().m_8055_(this.dog.m_20183_());
        Block dog_b0_block = dog_b0_state.m_60734_();
        boolean is_laying_bed = dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.m_204336_(BlockTags.f_13038_);
        return is_laying_bed;
    }

    private void incapacitatedHealWithBed(LivingEntity owner) {
        this.partialRecoverVal += 0.002f * (float)this.recoveryMultiplier;
        if (owner == null) {
            return;
        }
        if (this.dog.m_20280_((Entity)owner) > 100.0) {
            return;
        }
        this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
        if (!(this.dog.m_9236_() instanceof ServerLevel)) {
            return;
        }
        if (this.dog.f_19797_ % 10 != 0) {
            return;
        }
        ((ServerLevel)this.dog.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 1, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
    }

    private void healWithBandaid(BandaidState state) {
        switch (state) {
            case FULL: {
                this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
                break;
            }
            case HALF: {
                this.partialRecoverVal += 0.01f * (float)this.recoveryMultiplier;
                break;
            }
        }
    }

    public boolean canMove() {
        return this.dog.getIncapSyncState().bandaid == BandaidState.FULL;
    }

    public boolean shouldApplyCustomPushBehaviour(Entity target) {
        Dog other_dog;
        boolean only_normal_when = target instanceof Dog && (other_dog = (Dog)target).isDefeated();
        return !only_normal_when;
    }

    public void save(CompoundTag tag) {
        CompoundTag tg0 = new CompoundTag();
        IncapacitatedSyncState syncState = this.dog.getIncapSyncState();
        tg0.m_128405_("type", syncState.type.getId());
        tg0.m_128405_("bandaid", this.bandagesCount);
        tg0.m_128405_("poseid", syncState.poseId);
        tg0.m_128359_("incapMsg", this.incapMsg);
        tag.m_128365_("doggyIncapacitated", (Tag)tg0);
    }

    public void load(CompoundTag tag) {
        CompoundTag tg0 = tag.m_128469_("doggyIncapacitated");
        DefeatedType type = DefeatedType.byId(tg0.m_128451_("type"));
        int bandaid_count = tg0.m_128451_("bandaid");
        int poseId = tg0.m_128451_("poseid");
        this.incapMsg = tg0.m_128461_("incapMsg");
        this.bandagesCount = bandaid_count;
        this.dog.setIncapSyncState(new IncapacitatedSyncState(type, BandaidState.getState(bandaid_count), poseId));
    }

    public DogPose getPose() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogPose.DROWN;
        }
        switch (id) {
            default: {
                return DogPose.FAINTED;
            }
            case 1: 
        }
        return DogPose.FAINTED_2;
    }

    public DogAnimation getAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogAnimation.DROWN;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT;
            }
            case 1: 
        }
        return DogAnimation.FAINT_2;
    }

    private boolean isDogDeepInFluid() {
        FluidType type = this.dog.getMaxHeightFluidType();
        if (type.isAir()) {
            return false;
        }
        if (type == ForgeMod.LAVA_TYPE.get() && this.dog.m_5825_()) {
            return false;
        }
        double height = this.dog.getFluidTypeHeight(type);
        return height > 0.5;
    }

    private boolean showDrownPose() {
        return this.drownPoseTick > 20;
    }

    public DogAnimation getFaintStandAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.dog.m_20069_() || this.dog.m_20077_()) {
            return DogAnimation.NONE;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT_STAND_1;
            }
            case 1: 
        }
        return DogAnimation.FAINT_STAND_2;
    }

    public void setIncapMsg(String s) {
        if (s == null) {
            return;
        }
        if (((String)s).isEmpty()) {
            return;
        }
        if (((String)s).length() > 256) {
            s = ((String)s).substring(0, 250) + "..";
        }
        this.incapMsg = s;
    }

    public String getIncapMsg() {
        return this.incapMsg;
    }

    private boolean needWagyu() {
        return this.dog.getIncapSyncState().type == DefeatedType.STARVE;
    }

    public static class IncapacitatedSyncState {
        public static IncapacitatedSyncState NONE = new IncapacitatedSyncState(DefeatedType.NONE);
        public DefeatedType type = DefeatedType.NONE;
        public BandaidState bandaid = BandaidState.NONE;
        public int poseId = 0;

        public IncapacitatedSyncState(DefeatedType type) {
            this.type = type;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid) {
            this.type = type;
            this.bandaid = bandaid;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid, int poseId) {
            this.type = type;
            this.bandaid = bandaid;
            this.poseId = poseId;
        }

        public IncapacitatedSyncState copy() {
            return new IncapacitatedSyncState(this.type, this.bandaid, this.poseId);
        }

        public IncapacitatedSyncState updateBandaid(int bandaid_count) {
            BandaidState new_state = BandaidState.getState(bandaid_count);
            if (new_state == this.bandaid) {
                return this;
            }
            return new IncapacitatedSyncState(this.type, new_state, this.poseId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IncapacitatedSyncState)) {
                return false;
            }
            IncapacitatedSyncState state = (IncapacitatedSyncState)obj;
            if (this.type != state.type) {
                return false;
            }
            if (this.bandaid != state.bandaid) {
                return false;
            }
            return this.poseId == state.poseId;
        }
    }

    public static enum DefeatedType {
        NONE(0),
        BLOOD(1),
        BURN(2),
        POISON(3),
        DROWN(4),
        STARVE(5);

        private final int id;

        private DefeatedType(int id) {
            this.id = id;
        }

        public static DefeatedType byId(int i) {
            DefeatedType[] values = DefeatedType.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum BandaidState {
        NONE(0),
        HALF(1),
        FULL(2);

        private final int id;

        private BandaidState(int id) {
            this.id = id;
        }

        public static BandaidState byId(int i) {
            BandaidState[] values = BandaidState.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public static BandaidState getState(int bandaid_count) {
            if (bandaid_count <= 3) {
                return NONE;
            }
            if (bandaid_count <= 7) {
                return HALF;
            }
            return FULL;
        }

        public int getId() {
            return this.id;
        }
    }
}

