/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.common.item.DoubleDyableAccessoryItem;
import doggytalents.common.util.ColourCache;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DoubleDyableAccessory
extends Accessory {
    public DoubleDyableAccessory(Supplier<? extends AccessoryType> typeIn, Supplier<? extends ItemLike> itemIn) {
        super(typeIn, itemIn);
    }

    @Override
    public AccessoryInstance getDefault() {
        return new DoubleDyableAccessoryInstance((Accessory)this, 0, 0);
    }

    @Override
    public AccessoryInstance createInstance(FriendlyByteBuf buf) {
        int bg_color = buf.readInt();
        int fg_color = buf.readInt();
        return new DoubleDyableAccessoryInstance((Accessory)this, bg_color, fg_color);
    }

    @Override
    public void write(AccessoryInstance instance, FriendlyByteBuf buf) {
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            buf.writeInt(0);
            buf.writeInt(0);
            return;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        buf.writeInt(inst.getBgColorInteger());
        buf.writeInt(inst.getFgColorInteger());
    }

    @Override
    public void write(AccessoryInstance instance, CompoundTag compound) {
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            return;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        compound.m_128405_("dtn_bg_color", inst.getBgColorInteger());
        compound.m_128405_("dtn_fg_color", inst.getFgColorInteger());
    }

    @Override
    public AccessoryInstance read(CompoundTag compound) {
        int bg_color = 0;
        if (compound.m_128441_("dtn_bg_color")) {
            bg_color = compound.m_128451_("dtn_bg_color");
        } else if (compound.m_128441_("color")) {
            bg_color = compound.m_128451_("color");
        }
        int fg_color = 0;
        if (compound.m_128441_("dtn_fg_color")) {
            fg_color = compound.m_128451_("dtn_fg_color");
        } else if (compound.m_128441_("bdhat_fg_color")) {
            fg_color = compound.m_128451_("bdhat_fg_color");
        }
        return new DoubleDyableAccessoryInstance((Accessory)this, bg_color, fg_color);
    }

    @Override
    public AccessoryInstance createFromStack(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof DoubleDyableAccessoryItem) {
            DoubleDyableAccessoryItem doubleAccessory = (DoubleDyableAccessoryItem)item;
            return new DoubleDyableAccessoryInstance((Accessory)this, doubleAccessory.getBgColor(stackIn), doubleAccessory.getFgColor(stackIn));
        }
        return this.getDefault();
    }

    @Override
    public ItemStack getReturnItem(AccessoryInstance instance) {
        ItemStack returnStack = super.getReturnItem(instance);
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            return returnStack;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        Item item = returnStack.m_41720_();
        if (item instanceof DoubleDyableAccessoryItem) {
            DoubleDyableAccessoryItem birthday = (DoubleDyableAccessoryItem)item;
            birthday.setBgColor(returnStack, inst.getBgColorInteger());
            birthday.setFgColor(returnStack, inst.getFgColorInteger());
        }
        return returnStack;
    }

    public static class DoubleDyableAccessoryInstance
    extends AccessoryInstance {
        private ColourCache bgColor;
        private ColourCache fgColor;

        public DoubleDyableAccessoryInstance(Accessory typeIn, int bgColor, int fgColor) {
            this(typeIn, ColourCache.make(bgColor), ColourCache.make(fgColor));
        }

        public DoubleDyableAccessoryInstance(Accessory type, ColourCache bgColor, ColourCache fgColor) {
            super(type);
            this.bgColor = bgColor;
            this.fgColor = fgColor;
        }

        public float[] getBgColor() {
            return this.bgColor.getFloatArray();
        }

        public float[] getFgColor() {
            return this.fgColor.getFloatArray();
        }

        public int getBgColorInteger() {
            return this.bgColor.get();
        }

        public int getFgColorInteger() {
            return this.fgColor.get();
        }

        @Override
        public AccessoryInstance copy() {
            return new DoubleDyableAccessoryInstance(this.getAccessory(), this.bgColor, this.fgColor);
        }
    }
}

