/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class DogAvoidPushWhenIdleGoal
extends Goal {
    private Dog dog;
    private int cooldown = 0;
    private int grace = 0;

    public DogAvoidPushWhenIdleGoal(Dog dog) {
        this.dog = dog;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (!this.dog.canDogResistPush()) {
            return false;
        }
        return this.checkIfShouldBeginResisting();
    }

    public boolean m_8045_() {
        if (!this.dog.canDogResistPush()) {
            return false;
        }
        return this.grace > 0;
    }

    public void m_8056_() {
        this.grace = 3;
        this.dog.setDogResistingPush(true);
    }

    public void m_8037_() {
        if (this.grace > 0) {
            --this.grace;
        }
    }

    public void m_8041_() {
        this.grace = 0;
        this.dog.setDogResistingPush(false);
    }

    private boolean checkIfShouldBeginResisting() {
        boolean currently_damaging;
        Vec3 delta = this.dog.m_20184_();
        double delta_l = delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_;
        double xz_cap = this.dog.getDogPushResistXZCap();
        if (delta_l <= xz_cap * xz_cap) {
            return false;
        }
        Vec3 dog_pos = this.dog.m_20182_();
        Vec3 dog_pos_1 = new Vec3(dog_pos.f_82479_ + delta.f_82479_, dog_pos.f_82480_, dog_pos.f_82481_ + delta.f_82481_);
        BlockPos dog_b0 = BlockPos.m_274446_((Position)dog_pos);
        BlockPos dog_b1 = BlockPos.m_274446_((Position)dog_pos_1);
        BlockPathTypes blockType = this.dog.getBlockPathTypeViaAlterations(dog_b0);
        boolean bl = currently_damaging = blockType.getDanger() != null && this.dog.m_21439_(blockType) < 0.0f;
        if (currently_damaging) {
            this.cooldown = 10;
            return false;
        }
        if (!dog_b0.equals((Object)dog_b1)) {
            blockType = this.dog.getBlockPathTypeViaAlterations(dog_b1);
        }
        if (blockType.getDanger() != null) {
            return true;
        }
        if (blockType != BlockPathTypes.OPEN) {
            return false;
        }
        boolean noWalkable = true;
        for (int i = 1; i <= this.dog.m_6056_(); ++i) {
            BlockPathTypes type = this.dog.getBlockPathTypeViaAlterations(dog_b1.m_6625_(i));
            if (type == BlockPathTypes.OPEN) continue;
            noWalkable = type != BlockPathTypes.WALKABLE;
            break;
        }
        return noWalkable;
    }
}

