/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.RingSearchIterator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class DogFindWaterGoal
extends Goal {
    private static final int SEARCH_RANGE = 6;
    private Dog dog;
    private int searchAgainAt;
    private int holdTime;
    private BlockPos waterPos;
    private Path tempPath;

    public DogFindWaterGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.dog.m_5825_()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (!this.dog.m_6060_()) {
            return false;
        }
        this.waterPos = null;
        if (this.dog.f_19797_ >= this.searchAgainAt) {
            this.searchAgainAt = this.dog.f_19797_ + 10;
            this.waterPos = this.searchForWaterPos();
        }
        if (this.waterPos == null) {
            return false;
        }
        Path path = this.dog.m_21573_().m_7864_(this.waterPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.waterPos, 1, 1)) {
            this.searchAgainAt = this.dog.f_19797_ + 20;
            return false;
        }
        this.tempPath = path;
        return true;
    }

    public boolean m_8045_() {
        if (!this.dog.m_6060_()) {
            return false;
        }
        if (this.waterPos == null) {
            return false;
        }
        return this.holdTime > 0;
    }

    public void m_8056_() {
        this.dog.m_21573_().m_26536_(this.tempPath, (double)this.dog.getUrgentSpeedModifier());
        this.tempPath = null;
        this.holdTime = 5;
    }

    public void m_8041_() {
        this.tempPath = null;
        this.waterPos = null;
    }

    public void m_8037_() {
        PathNavigation nav = this.dog.m_21573_();
        if (this.waterPos != null && !this.isWaterPos(this.waterPos)) {
            this.waterPos = null;
        }
        if (nav.m_26571_()) {
            if (this.holdTime == 5 && this.waterPos != null && nav.m_26571_() && this.dog.m_20183_().m_123331_((Vec3i)this.waterPos) <= 1.0) {
                this.dog.m_21566_().m_6849_((double)this.waterPos.m_123341_() + 0.5, (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_() + 0.5, 1.0);
            }
            --this.holdTime;
        }
    }

    private BlockPos searchForWaterPos() {
        for (BlockPos pos : RingSearchIterator.createWithRandom(this.dog.m_20183_(), 4, 6, true, this.dog.m_217043_())) {
            if (!this.isWaterPos(pos)) continue;
            return pos;
        }
        return null;
    }

    private boolean isWaterPos(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (this.dog.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        return this.dog.m_9236_().m_46758_(pos);
    }
}

