/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;

public class DogDrownAction
extends AnimationAction {
    private int tickTillShink = 70;
    private int tickSink = 0;
    private boolean swimming = false;

    public DogDrownAction(Dog dog) {
        super(dog, DogAnimation.DROWN);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getState() == TriggerableAction.ActionState.FINISHED) {
            return;
        }
        if (this.tickTillShink <= 0 && !this.dog.isDogSwimming()) {
            this.dog.setDogSwimming(true);
            this.swimming = true;
        }
        if (this.tickTillShink <= 0) {
            ++this.tickSink;
        }
        if (this.tickSink >= 50 && this.swimming) {
            this.dog.setDogSwimming(false);
        }
        --this.tickTillShink;
    }

    @Override
    public boolean validateAnim() {
        if (!this.stillInLiquid()) {
            return false;
        }
        return super.validateAnim();
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.swimming) {
            this.dog.setDogSwimming(false);
        }
    }

    private boolean stillInLiquid() {
        return this.dog.m_20077_() || this.dog.m_20069_();
    }
}

