/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.accessory.DoubleDyableAccessory;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DoubleDyableAccessoryItem
extends AccessoryItem {
    private Supplier<? extends DoubleDyableAccessory> accessory;

    public DoubleDyableAccessoryItem(Supplier<? extends DoubleDyableAccessory> accessoryIn, Item.Properties properties) {
        super(accessoryIn, properties);
        this.accessory = accessoryIn;
    }

    @Override
    public AccessoryInstance createInstance(AbstractDog dogIn, ItemStack stack, Player playerIn) {
        return this.accessory.get().createFromStack(stack);
    }

    public int getBgColor(ItemStack stack) {
        int defColor = this.getDefaultBgColor();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return defColor;
        }
        if (tag.m_128425_("doggytalents_bg_color", 3)) {
            return 0xFF000000 | tag.m_128451_("doggytalents_bg_color");
        }
        if (tag.m_128425_("color", 3)) {
            return 0xFF000000 | tag.m_128451_("color");
        }
        return defColor;
    }

    public int getFgColor(ItemStack stack) {
        int defColor = this.getDefaultFgColor();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return defColor;
        }
        if (tag.m_128425_("doggytalents_fg_color", 3)) {
            return 0xFF000000 | tag.m_128451_("doggytalents_fg_color");
        }
        if (tag.m_128425_("dtn_bdhat_foreground", 3)) {
            return 0xFF000000 | tag.m_128451_("dtn_bdhat_foreground");
        }
        return defColor;
    }

    public void setBgColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("doggytalents_bg_color", color);
    }

    public void setFgColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("doggytalents_fg_color", color);
    }

    public static ItemStack copyAndSetColorForStack(ItemStack stack, List<DyeColor> dye, boolean fg_color) {
        Item item = stack.m_41720_();
        if (!(item instanceof DoubleDyableAccessoryItem)) {
            return ItemStack.f_41583_;
        }
        DoubleDyableAccessoryItem accessory = (DoubleDyableAccessoryItem)item;
        stack = stack.m_255036_(1);
        int color = Util.colorDye(-1, dye);
        if (fg_color) {
            accessory.setFgColor(stack, color);
        } else {
            accessory.setBgColor(stack, color);
        }
        return stack;
    }

    public int getDefaultBgColor() {
        return -1;
    }

    public int getDefaultFgColor() {
        return this.getDefaultBgColor();
    }
}

