/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.forward_imitate.EntityUtil_1_20_under;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ObjectUtils;

public class MobRetrieverTalent
extends TalentInstance {
    private LivingEntity targetEntity;

    public MobRetrieverTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        this.updateRidingPassanger(dog);
        this.updateAndSetRetrieveTarget(dog);
    }

    private void updateRidingPassanger(Dog dog) {
        Entity riding = dog.m_146895_();
        if (riding == null) {
            return;
        }
        if (riding instanceof Player) {
            return;
        }
        if (!this.canStillRideTarget(dog, riding)) {
            dog.m_19877_();
        }
    }

    private void updateAndSetRetrieveTarget(Dog dog) {
        if (this.targetEntity == null) {
            return;
        }
        LivingEntity target = this.targetEntity;
        this.targetEntity = null;
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        if (dog.isBusy() || !this.readyForNewRider(dog)) {
            return;
        }
        if (dog.m_21827_()) {
            return;
        }
        dog.triggerAction(new DogRetrieveMobAction(dog, target, this));
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            dog.m_19877_();
        }
    }

    public boolean isValidTarget(Dog dog, LivingEntity target) {
        TamableAnimal otherDog;
        if (target == dog) {
            return false;
        }
        if (target.m_20280_((Entity)dog) >= (double)(MobRetrieverTalent.getSelectTargetRange() * MobRetrieverTalent.getSelectTargetRange())) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_5833_()) {
            return false;
        }
        if (target.m_20160_()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        boolean onlyLeashable = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_LEASHABLE.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (!(target instanceof Mob)) {
            return false;
        }
        if (onlyLeashable && !EntityUtil_1_20_under.canBeLeashed((Mob)target, dog)) {
            return false;
        }
        if (target instanceof Player) {
            return false;
        }
        if (target instanceof Enemy) {
            return false;
        }
        if (target.m_6095_().m_204039_(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof TamableAnimal && (otherDog = (TamableAnimal)target).m_21805_() != null && ObjectUtils.notEqual((Object)otherDog.m_21805_(), (Object)dog.m_21805_())) {
            return false;
        }
        return this.canLevelRideTarget(dog, (Entity)target);
    }

    private boolean canStillRideTarget(Dog dog, Entity target) {
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_5833_()) {
            return false;
        }
        if (target.m_20160_()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (dog.m_21825_()) {
            return false;
        }
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!(target instanceof Mob)) {
            return false;
        }
        if (target instanceof Enemy) {
            return false;
        }
        if (target.m_6095_().m_204039_(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal otherDog = (TamableAnimal)target;
            if (dog.m_21805_() != null && ObjectUtils.notEqual((Object)otherDog.m_21805_(), (Object)dog.m_21805_())) {
                return false;
            }
        }
        return this.canLevelRideTarget(dog, target);
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (!dog.m_9236_().f_46443_) {
            this.maybeDropRiding(dog);
        }
        return super.gettingAttackedFrom(dog, source, damage);
    }

    private void maybeDropRiding(AbstractDog dog) {
        TamableAnimal otherDog;
        if (!dog.m_20160_()) {
            return;
        }
        Entity passenger = dog.m_146895_();
        if (passenger == null) {
            return;
        }
        if (passenger instanceof Player) {
            return;
        }
        if (passenger instanceof TamableAnimal && (otherDog = (TamableAnimal)passenger).m_269323_() == dog.m_269323_()) {
            return;
        }
        dog.m_19877_();
    }

    private boolean canLevelRideTarget(Dog dog, Entity target) {
        int lvl = this.level();
        float target_bbW = target.m_20205_();
        float target_bbH = target.m_20206_();
        float w_ratio = target_bbW / dog.getDogVisualBbWidth();
        float h_ratio = target_bbH / dog.getDogVisualBbHeight();
        if (target_bbW >= 1.0f) {
            return false;
        }
        if ((double)w_ratio > 1.2) {
            return false;
        }
        if (lvl >= 5) {
            return h_ratio <= 2.0f;
        }
        if (lvl >= 3) {
            return (double)h_ratio <= 1.5;
        }
        return h_ratio <= 1.0f;
    }

    private boolean readyForNewRider(Dog dog) {
        return dog.isDoingFine() && !dog.m_21825_() && !dog.m_20160_();
    }

    public void setTarget(Dog dog, LivingEntity target) {
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        this.targetEntity = target;
    }

    public static Optional<Dog> chooseNearestDog(Player player, Level level) {
        List valid_dogs = level.m_6443_(Dog.class, player.m_20191_().m_82377_(4.0, 2.0, 4.0), d -> {
            if (!d.isDoingFine()) {
                return false;
            }
            if (d.getDogLevel((Supplier)DoggyTalents.MOB_RETRIEVER) <= 0) {
                return false;
            }
            return !d.isBusy();
        });
        if (valid_dogs.isEmpty()) {
            return Optional.empty();
        }
        double min_dist = ((Dog)valid_dogs.get(0)).m_20280_((Entity)player);
        Dog choosen_dog = (Dog)valid_dogs.get(0);
        for (Dog dog : valid_dogs) {
            double dist = dog.m_20280_((Entity)player);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            choosen_dog = dog;
        }
        return Optional.of(choosen_dog);
    }

    @Override
    public InteractionResult blockIdleAnim(AbstractDog dogIn) {
        if (dogIn.m_20160_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static int getSelectTargetRange() {
        return 20;
    }

    public static class DogRetrieveMobAction
    extends TriggerableAction {
        private MobRetrieverTalent inst;
        private LivingEntity target;
        private int tickTillPathRecalc;
        private int stopDist = 3;
        private boolean isBringingBack = false;
        private LivingEntity owner = null;

        public DogRetrieveMobAction(Dog dog, LivingEntity target, MobRetrieverTalent inst) {
            super(dog, false, false);
            this.target = target;
            this.inst = inst;
        }

        @Override
        public void onStart() {
        }

        @Override
        public void tick() {
            if (!this.inst.isValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isBringingBack && !this.dog.m_20197_().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.dog.m_20197_().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.owner == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && (!this.ownerIsStillThere() || this.returnedToOwner())) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack) {
                this.returnToOwner();
            } else {
                this.goGetMob();
            }
        }

        private void goGetMob() {
            if (this.dog.m_20280_((Entity)this.target) > (double)(this.stopDist * this.stopDist)) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.m_21573_().m_26573_();
                this.target.m_20329_((Entity)this.dog);
                this.owner = this.dog.m_269323_();
                this.isBringingBack = true;
            }
        }

        private void returnToOwner() {
            if (this.dog.m_20280_((Entity)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.owner, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            }
        }

        @Override
        public void onStop() {
        }

        private boolean ownerIsStillThere() {
            if (!this.owner.m_6084_()) {
                return false;
            }
            if (this.owner.m_5833_()) {
                return false;
            }
            return !(this.owner.m_20280_((Entity)this.dog) > 256.0);
        }

        private boolean returnedToOwner() {
            return this.dog.m_20280_((Entity)this.owner) <= (double)(this.stopDist * this.stopDist);
        }
    }
}

