/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ForgeEventFactory;

public class RescueDogTalent
extends TalentInstance {
    private boolean renderBox = true;
    private final int SEARCH_RADIUS = 12;
    private int tickTillSearch = 0;
    private int healCooldown = 0;

    public RescueDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.healCooldown > 0) {
            --this.healCooldown;
            return;
        }
        if (dog.readyForNonTrivialAction() && !dog.getMode().shouldAttack() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            LivingEntity target = this.findHealTarget(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerRescueAction(dog, target);
            }
        }
    }

    private void triggerRescueAction(Dog dog, @Nonnull LivingEntity target) {
        dog.triggerAction(new RescueAction(dog, this, target));
    }

    public int healCost(AbstractDog dog, LivingEntity target) {
        int cost = this.level() >= 5 ? 10 : 20;
        return cost;
    }

    public float healAmount(AbstractDog dog, LivingEntity target) {
        float bonus = 0.0f;
        float chance = dog.m_217043_().m_188501_();
        if (this.level() >= 3) {
            if ((double)chance > 0.8) {
                bonus = 3.0f;
            } else if ((double)chance > 0.55) {
                bonus = 2.0f;
            } else if ((double)chance > 0.25) {
                bonus = 1.0f;
            }
        }
        return (float)Mth.m_14107_((double)((double)this.level() * 1.5)) + bonus * 2.0f;
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    private void heal(AbstractDog dog, LivingEntity e) {
        if (this.healCooldown > 0) {
            return;
        }
        dog.setDogHunger(dog.getDogHunger() - (float)this.healCost(dog, e));
        if (this.level() >= 5) {
            this.forceHealTarget(dog, e, this.healAmount(dog, e));
        } else {
            e.m_5634_(this.healAmount(dog, e));
        }
        if (dog.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)dog.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, e.m_20185_(), e.m_20186_(), e.m_20189_(), this.level * 8, (double)e.m_20205_(), (double)0.8f, (double)e.m_20205_(), 0.1);
        }
        this.healCooldown = dog.m_217043_().m_188503_(3) * 20;
    }

    private void forceHealTarget(AbstractDog dog, LivingEntity e, float add) {
        if (add <= 0.0f) {
            return;
        }
        float add1 = ForgeEventFactory.onLivingHeal((LivingEntity)e, (float)add);
        add = Math.max(add1, add);
        float h = e.m_21223_();
        if (h > 0.0f) {
            e.m_21153_(h + add);
        }
    }

    private boolean isTargetLowHealth(AbstractDog dog, LivingEntity e) {
        return (double)e.m_21223_() <= 8.0;
    }

    private boolean canAffordToHealTarget(AbstractDog dog, LivingEntity e) {
        return dog.getDogHunger() - 10.0f >= (float)this.healCost(dog, e);
    }

    private boolean canHealTarget(AbstractDog dog, LivingEntity e) {
        return dog.m_20280_((Entity)e) <= 5.0 && dog.m_21574_().m_148306_((Entity)e);
    }

    private LivingEntity findHealTarget(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<LivingEntity> healTargets = new ArrayList<LivingEntity>();
        Predicate<LivingEntity> lowHealthAndInWitness = e -> this.isTargetLowHealth(dog, (LivingEntity)e) && dog.m_21574_().m_148306_((Entity)e);
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return null;
        }
        if (lowHealthAndInWitness.test(owner)) {
            healTargets.add(owner);
        }
        if (!(dogs = dog.m_9236_().m_6443_(AbstractDog.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), d -> d.m_269323_() == owner && lowHealthAndInWitness.test((LivingEntity)d))).isEmpty()) {
            healTargets.addAll(dogs);
        }
        if (!(wolves = dog.m_9236_().m_6443_(Wolf.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), w -> w.m_269323_() == owner && lowHealthAndInWitness.test((LivingEntity)w))).isEmpty()) {
            healTargets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.m_9236_().m_6443_(Player.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), p -> p.m_7307_((Entity)owner) && lowHealthAndInWitness.test((LivingEntity)p))).isEmpty()) {
            healTargets.addAll(teamPlayers);
        }
        return this.selectHealTarget(dog, healTargets);
    }

    private LivingEntity selectHealTarget(AbstractDog dog, ArrayList<LivingEntity> healTargets) {
        if (healTargets.isEmpty()) {
            return null;
        }
        LivingEntity target = healTargets.get(0);
        double mindistanceSqr = target.m_20280_((Entity)dog);
        LivingEntity owner = dog.m_269323_();
        for (LivingEntity i : healTargets) {
            if (owner == i) {
                return i;
            }
            double d = i.m_20280_((Entity)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    private boolean stillValidTarget(Dog dog, LivingEntity target) {
        Dog d;
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.isTargetLowHealth(dog, target)) {
            return false;
        }
        if (!this.canAffordToHealTarget(dog, target)) {
            return false;
        }
        if (dog.m_20280_((Entity)target) > 400.0) {
            return false;
        }
        return !(target instanceof Dog) || !(d = (Dog)target).isDefeated();
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.renderBox = compound.m_128471_("renderBox");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("renderBox", this.renderBox);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.RESCUE_DOG_RENDER.get()) {
            return this.renderBox;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.RESCUE_DOG_RENDER.get()) {
            this.renderBox = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.RESCUE_DOG_RENDER.get());
    }

    public boolean renderBox() {
        return this.renderBox;
    }

    public void setRenderBox(boolean render) {
        this.renderBox = render;
    }

    public static class RescueAction
    extends TriggerableAction {
        private RescueDogTalent talentInst;
        @Nonnull
        private LivingEntity target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public RescueAction(Dog dog, RescueDogTalent talentInst, @Nonnull LivingEntity target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public float getDistanceForFollowOwner() {
            return 20.0f;
        }

        @Override
        public void tick() {
            if (this.dog.getMode().shouldAttack()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.m_20280_((Entity)this.target) > 4.0) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else if (this.talentInst.canHealTarget(this.dog, this.target)) {
                this.talentInst.heal(this.dog, this.target);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }
    }
}

