/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.tool_actions.DogBridgingAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class DogBridging {
    public static Optional<Pair<ItemStack, BlockItem>> getBridgingMaterial(DoggyToolsTalent inst, Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(inst.level()); ++i) {
            BlockItem block_item;
            Item item;
            ItemStack stack = inst.getTools().getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem) || (block_item = (BlockItem)item).m_40614_().m_204297_().m_203656_(DoggyTags.BRIDGING_DOG_BLACKLIST)) continue;
            return Optional.of(Pair.of((Object)stack, (Object)block_item));
        }
        return Optional.empty();
    }

    public static boolean isValidBridgingDog(DoggyToolsTalent inst, Dog dog) {
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING.get()).booleanValue()) {
            return false;
        }
        if (inst.level() < inst.getTalent().getMaxLevel()) {
            return false;
        }
        Optional<Pair<ItemStack, BlockItem>> pair = DogBridging.getBridgingMaterial(inst, dog);
        return pair.isPresent();
    }

    public static boolean isValidBridgingDog(Dog dog) {
        Optional<DoggyToolsTalent> inst = dog.getTalent((Talent)DoggyTalents.DOGGY_TOOLS.get(), DoggyToolsTalent.class);
        if (!inst.isPresent()) {
            return false;
        }
        return DogBridging.isValidBridgingDog(inst.get(), dog);
    }

    public static void equipBridgingStack(DoggyToolsTalent inst, Dog dog) {
        Optional<Pair<ItemStack, BlockItem>> pair = DogBridging.getBridgingMaterial(inst, dog);
        if (!pair.isPresent()) {
            return;
        }
        dog.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)pair.get().getLeft());
    }

    public static Optional<Pair<Dog, DoggyToolsTalent>> getNearestBridgingDog(Player player, Level level) {
        List valid_dogs = level.m_6443_(Dog.class, player.m_20191_().m_82377_(7.0, 2.0, 7.0), d -> {
            if (!d.isDoingFine()) {
                return false;
            }
            if (d.isBusy()) {
                return false;
            }
            if (d.m_21827_()) {
                return false;
            }
            return DogBridging.isValidBridgingDog(d);
        });
        if (valid_dogs.isEmpty()) {
            return Optional.empty();
        }
        double min_dist = ((Dog)valid_dogs.get(0)).m_20280_((Entity)player);
        Dog choosen_dog = (Dog)valid_dogs.get(0);
        for (Dog dog : valid_dogs) {
            double dist = dog.m_20280_((Entity)player);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            choosen_dog = dog;
        }
        Optional<DoggyToolsTalent> inst = choosen_dog.getTalent((Talent)DoggyTalents.DOGGY_TOOLS.get(), DoggyToolsTalent.class);
        if (!inst.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)choosen_dog, (Object)inst.get()));
    }

    public static Optional<Integer> getBridgingLimit() {
        int limit = (Integer)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING_LIMIT.get();
        if (limit <= 0) {
            return Optional.empty();
        }
        return Optional.of(limit);
    }

    public static boolean checkIfReachedBridgingLimit(Player player) {
        Optional<Integer> limit_optional = DogBridging.getBridgingLimit();
        if (!limit_optional.isPresent()) {
            return false;
        }
        int limit = limit_optional.get();
        DogLocationStorage storage = DogLocationStorage.get(player.m_20194_());
        int current_count = storage.bridgingDogLimitMap.getOrDefault(player.m_20148_(), 0);
        return current_count >= limit;
    }

    public static void incBridgingCount(LivingEntity player) {
        DogLocationStorage storage = DogLocationStorage.get(player.m_20194_());
        storage.bridgingDogLimitMap.compute(player.m_20148_(), (uuid, old_val) -> {
            if (old_val == null) {
                return 1;
            }
            return old_val + 1;
        });
    }

    public static void decBridgingCount(LivingEntity player) {
        DogLocationStorage storage = DogLocationStorage.get(player.m_20194_());
        storage.bridgingDogLimitMap.computeIfPresent(player.m_20148_(), (uuid, old_val) -> {
            if (old_val == null) {
                return null;
            }
            int new_val = old_val - 1;
            if (new_val <= 0) {
                return null;
            }
            return new_val;
        });
    }

    public static void useBridgingWhistle(WhistleItem item, Player owner, Level level) {
        if (level.f_46443_) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING.get()).booleanValue()) {
            return;
        }
        if (DogBridging.checkIfReachedBridgingLimit(owner)) {
            owner.m_213846_((Component)Component.m_237110_((String)"dogcommand.bridging.limit_exceeded", (Object[])new Object[]{DogBridging.getBridgingLimit().orElse(0)}).m_130940_(ChatFormatting.RED));
            owner.m_36335_().m_41524_((Item)item, 20);
            return;
        }
        Optional<Pair<Dog, DoggyToolsTalent>> pair_optional = DogBridging.getNearestBridgingDog(owner, level);
        if (!pair_optional.isPresent()) {
            return;
        }
        Pair<Dog, DoggyToolsTalent> pair = pair_optional.get();
        Dog dog = (Dog)pair.getLeft();
        DoggyToolsTalent inst = (DoggyToolsTalent)pair.getRight();
        DogBridgingAction action = new DogBridgingAction(dog, (LivingEntity)owner, owner.m_6080_(), owner.m_20183_(), inst);
        if (dog.triggerAction(action)) {
            DogBridging.incBridgingCount((LivingEntity)owner);
        }
        owner.m_213846_((Component)Component.m_237110_((String)"dogcommand.bridging", (Object[])new Object[]{dog.m_7755_().getString()}));
        owner.m_36335_().m_41524_((Item)item, 20);
    }

    public static void onBridgingActionStop(LivingEntity owner) {
        DogBridging.decBridgingCount(owner);
    }
}

