/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.mojang.datafixers.util.Pair;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.item.DogEddibleItem;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class DogFoodUtil {
    private static final MeatFoodHandler meat_food_handler_limited = new MeatFoodHandler();

    public static boolean isMeat(ItemStack stack) {
        return Optional.ofNullable(stack.getFoodProperties(null)).filter(x -> x.m_38746_()).isPresent() || (Boolean)ConfigHandler.SERVER.DOG_CAN_EAT_ALL_FOOD.get() != false && stack.getFoodProperties(null) != null;
    }

    public static MeatFoodHandler limitedMeatFoodHandler() {
        return meat_food_handler_limited;
    }

    public static int dogFindFoodInInv(Dog dog, boolean findHealingFood, ItemStackHandler inv) {
        return DogFoodUtil.dogFindFoodInInv(dog, dog, findHealingFood, inv);
    }

    public static int dogFindFoodInInv(Dog finder, Dog target, boolean findHealingFood, ItemStackHandler inv) {
        int eddibleFoodId = DogFoodUtil.dogFindBestDogEddibleFood(finder, target, findHealingFood, inv);
        if (eddibleFoodId >= 0) {
            return eddibleFoodId;
        }
        int meatFoodId = DogFoodUtil.dogFindMeatFood(finder, target, inv);
        if (meatFoodId >= 0) {
            return meatFoodId;
        }
        return -1;
    }

    public static int dogFindBestDogEddibleFood(Dog finder, Dog target, boolean findHealingFood, ItemStackHandler inv) {
        ItemStackHandler inventory = inv;
        if (inventory == null) {
            return -1;
        }
        float minNutrition = -1.0f;
        int selectedStack = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            DogEddibleItem eddible;
            ItemStack stack = inventory.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof DogEddibleItem) || !(eddible = (DogEddibleItem)item).canConsume(target, stack, (Entity)finder)) continue;
            if (findHealingFood && DogFoodUtil.checkRegenEffects(target, stack, eddible)) {
                return i;
            }
            float addedNutrition = eddible.getAddedHungerWhenDogConsume(stack, target);
            if (minNutrition < 0.0f) {
                minNutrition = addedNutrition;
                selectedStack = i;
                continue;
            }
            if (!(minNutrition > addedNutrition)) continue;
            minNutrition = addedNutrition;
            selectedStack = i;
        }
        return selectedStack;
    }

    private static boolean checkRegenEffects(AbstractDog target, ItemStack stack, DogEddibleItem item) {
        List<Pair<MobEffectInstance, Float>> effects = item.getAdditionalEffectsWhenDogConsume(stack, target);
        for (Pair<MobEffectInstance, Float> pair : effects) {
            MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
            if (effect.m_19544_() != MobEffects.f_19605_) continue;
            return true;
        }
        return false;
    }

    public static int dogFindMeatFood(Dog finder, Dog target, ItemStackHandler inv) {
        ItemStackHandler inventory = inv;
        if (inventory == null) {
            return -1;
        }
        int minor_meat_id = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            FoodProperties food;
            ItemStack stack = inventory.getStackInSlot(i);
            if (!meat_food_handler_limited.canConsume(target, stack, (Entity)finder) || (food = ItemUtil.food(stack)) == null) continue;
            if (food.m_38744_() >= 6) {
                return i;
            }
            if (minor_meat_id >= 0) continue;
            minor_meat_id = i;
        }
        return minor_meat_id;
    }

    public static boolean tryFeed(Dog dog, boolean findHealingFood, ItemStackHandler inv) {
        return DogFoodUtil.tryFeed(dog, dog, findHealingFood, inv);
    }

    public static boolean tryFeed(Dog dog, Dog feeder, boolean findHealingFood, ItemStackHandler inv) {
        int foodSlot = DogFoodUtil.dogFindFoodInInv(feeder, dog, findHealingFood, inv);
        if (foodSlot < 0) {
            return false;
        }
        ItemStack feedStack = inv.getStackInSlot(foodSlot).m_41777_();
        Item feedItem = feedStack.m_41720_();
        if (feedItem instanceof IDogEddible) {
            IDogEddible eddible = (IDogEddible)feedItem;
            eddible.consume(dog, feedStack, (Entity)feeder);
        } else {
            DogFoodUtil.limitedMeatFoodHandler().consume(dog, feedStack, (Entity)feeder);
        }
        inv.setStackInSlot(foodSlot, feedStack);
        return true;
    }

    public static InteractionResult tryFeedAny(AbstractDog dog, @Nullable Entity feeder, IItemHandlerModifiable inv) {
        int found_food_id = -1;
        IDogFoodHandler found_food = null;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            Optional<IDogFoodHandler> food = FoodHandler.getMatch(dog, stack, feeder);
            if (!food.isPresent()) continue;
            found_food_id = i;
            found_food = food.get();
            break;
        }
        if (found_food_id < 0 || found_food == null) {
            return InteractionResult.PASS;
        }
        ItemStack feed_stack = inv.getStackInSlot(found_food_id).m_41777_();
        InteractionResult response = found_food.consume(dog, feed_stack, feeder);
        inv.setStackInSlot(found_food_id, feed_stack);
        return response;
    }
}

