/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DogGunpowderProjectileRenderer
extends EntityRenderer<DogGunpowderProjectile> {
    private ItemRenderer itemRenderer;
    private ItemStack renderStack;

    public DogGunpowderProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.itemRenderer = ctx.getItemRenderer();
        this.renderStack = new ItemStack((ItemLike)Items.GUNPOWDER);
    }

    public void render(DogGunpowderProjectile dogFood, float yRot, float pTick, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        this.itemRenderer.renderStatic(this.renderStack, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, stack, buffer, null, dogFood.getId());
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(DogGunpowderProjectile proj) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

