/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.framework.types.TextType;
import doggytalents.client.screen.framework.widget.FlatButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultiLineFlatButton
extends FlatButton {
    private final int LINE_SPACING = 2;
    private final int PADDING_LEFT = 6;
    private List<FormattedCharSequence> lines;
    private TextType.Align align = TextType.Align.MIDDLE;

    public MultiLineFlatButton(int x, int y, int width, int height, int r_pad, Component text, FlatButton.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress);
        this.lines = this.font.split((FormattedText)text, width - r_pad);
    }

    public MultiLineFlatButton setTextAlign(TextType.Align align) {
        this.align = align;
        return this;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.active) {
            return;
        }
        int cl = this.maskColor(this.buttonColor, this.isHovered);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, cl);
        if (this.align == TextType.Align.LEFT) {
            this.drawLeft(graphics);
        } else if (this.align == TextType.Align.MIDDLE) {
            this.drawCentered(graphics);
        }
    }

    private void drawCentered(GuiGraphics graphics) {
        int mX = this.getX() + this.width / 2;
        int mY = this.getY() + this.height / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTY = mY - text_height / 2;
        for (FormattedCharSequence line : this.lines) {
            int pTX = mX - this.font.width(line) / 2;
            graphics.drawString(this.font, line, pTX, pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawLeft(GuiGraphics graphics) {
        int mX = this.getX() + this.width / 2;
        int mY = this.getY() + this.height / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTX = this.getX() + 6;
        int pTY = mY - text_height / 2;
        for (FormattedCharSequence line : this.lines) {
            graphics.drawString(this.font, line, pTX, pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawRight(PoseStack stack) {
    }
}

