/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogRandomStandIdleGoal
extends Goal {
    private Dog dog;
    private int stopTick;
    private int startTick;
    private boolean jumped;
    private DogAnimation currentAnimation = DogAnimation.NONE;

    public DogRandomStandIdleGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        double use_chance;
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.isOnFire()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        double d = use_chance = this.dog.isChopinTail() ? 0.08 : 0.02;
        if ((double)this.dog.getRandom().nextFloat() >= use_chance) {
            return false;
        }
        this.currentAnimation = this.getIdleAnim();
        return this.currentAnimation != DogAnimation.NONE;
    }

    public boolean canContinueToUse() {
        if (!this.dog.onGround() && this.currentAnimation != DogAnimation.BACKFLIP) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        this.stopTick = this.dog.tickCount + this.currentAnimation.getLengthTicks();
        this.startTick = this.dog.tickCount;
        this.jumped = false;
        this.dog.setAnimForIdle(this.currentAnimation);
    }

    public void tick() {
        if (this.currentAnimation == DogAnimation.BACKFLIP) {
            this.checkJumpIfBackfilip();
        }
    }

    private void checkJumpIfBackfilip() {
        if (!this.jumped && this.dog.tickCount - this.startTick >= 3) {
            this.jumped = true;
            this.dog.getJumpControl().jump();
        }
    }

    public void stop() {
        if (this.dog.getAnim() == this.currentAnimation) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private DogAnimation getIdleAnim() {
        float r = this.dog.getRandom().nextFloat();
        if (this.dog.isChopinTail()) {
            if (r <= 0.1f) {
                return DogAnimation.NONE;
            }
            if (r <= 0.4f) {
                return DogAnimation.BACKFLIP;
            }
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.02f) {
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.08f) {
            return DogAnimation.DIG;
        }
        if (r <= 0.35f) {
            return DogAnimation.STRETCH;
        }
        return DogAnimation.NONE;
    }
}

