/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.texture;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class DogSkinData {
    public static DogSkinData NULL = new DogSkinData("", Version.VERSION_0);
    private String hash = "";
    private Version version = Version.VERSION_0;

    public DogSkinData(String hash, Version version) {
        this.hash = hash == null ? "" : hash;
        this.version = version == null ? Version.VERSION_0 : version;
    }

    public String getHash() {
        return this.hash;
    }

    public Version getVersion() {
        return this.version;
    }

    public DogSkinData copy() {
        return new DogSkinData(this.hash, this.version);
    }

    public void save(CompoundTag tag) {
        CompoundTag tag0 = new CompoundTag();
        tag0.putInt("version", this.version.getId());
        tag0.putString("hash", this.hash);
        tag.put("doggytalents_dog_skin", (Tag)tag0);
    }

    public static DogSkinData readFromTag(CompoundTag compound) {
        if (compound.contains("doggytalents_dog_skin", 10)) {
            return DogSkinData.readNewer(compound.getCompound("doggytalents_dog_skin"));
        }
        if (compound.contains("customSkinHash", 8)) {
            return DogSkinData.readFromString(compound.getString("customSkinHash"));
        }
        return NULL;
    }

    private static DogSkinData readNewer(CompoundTag tag) {
        int version_int = tag.getInt("version");
        String hash = tag.getString("hash");
        return new DogSkinData(hash, Version.fromId(version_int));
    }

    private static DogSkinData readFromString(String hash) {
        return new DogSkinData(hash, Version.VERSION_0);
    }

    public static enum Version {
        VERSION_0(0),
        VERSION_1(1);

        private final int id;
        private static final Version[] VALUES;

        private Version(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Version fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                id = 3;
            }
            return VALUES[id];
        }

        static {
            VALUES = (Version[])Arrays.stream(Version.values()).sorted(Comparator.comparingInt(Version::getId)).toArray(Version[]::new);
        }
    }
}

