/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogFetchAction;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ThrowableItem
extends Item
implements IThrowableItem {
    public Supplier<? extends Item> altBone;
    public Supplier<? extends Item> renderBone;

    public ThrowableItem(Supplier<? extends Item> altBone, Supplier<? extends Item> renderBone, Item.Properties properties) {
        super(properties);
        this.altBone = altBone;
        this.renderBone = renderBone;
    }

    @Override
    public ItemStack getReturnStack(ItemStack stack) {
        ItemStack returnStack = new ItemStack((ItemLike)this.altBone.get());
        if (ItemUtil.hasTag(stack)) {
            ItemUtil.copyTag(stack, returnStack);
        }
        return returnStack;
    }

    @Override
    public ItemStack getCustomRenderStack(ItemStack stack) {
        return new ItemStack((ItemLike)this.renderBone.get());
    }

    public void setHeadingFromThrower(ItemEntity entityItem, Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.setThrowableHeading(entityItem, f, f1, f2, velocity, inaccuracy);
        Vec3 vec3d = entityThrower.getDeltaMovement();
        entityItem.setDeltaMovement(entityItem.getDeltaMovement().add(vec3d.x, entityThrower.onGround() ? 0.0 : vec3d.y, vec3d.z));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemStackIn = playerIn.getItemInHand(handIn);
        worldIn.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.random.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            ItemStack stack = itemStackIn.copy();
            stack.setCount(1);
            ItemEntity entityitem = new ItemEntity(playerIn.level(), playerIn.getX(), playerIn.getY() - (double)0.3f + (double)playerIn.getEyeHeight(), playerIn.getZ(), stack);
            entityitem.setPickUpDelay(20);
            this.setHeadingFromThrower(entityitem, (Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.2f, 1.0f);
            worldIn.addFreshEntity((Entity)entityitem);
            this.triggerNearbyDogs(playerIn, entityitem);
        }
        if (!playerIn.getAbilities().instabuild) {
            itemStackIn.shrink(1);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    private void triggerNearbyDogs(@Nonnull Player player, @Nonnull ItemEntity entityitem) {
        int RADIUS = 5;
        List dogs = player.level().getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(5.0, 3.0, 5.0), d -> d.canInteract((LivingEntity)player) && !d.isBusy() && !d.hasBone() && !d.isOrderedToSit() && d.getMode() == DogMode.DOCILE);
        for (Dog dog : dogs) {
            dog.triggerAction(new DogFetchAction(dog, (LivingEntity)player, entityitem));
        }
    }

    public void setThrowableHeading(ItemEntity entityItem, double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).normalize().add(entityItem.level().random.nextGaussian() * (double)0.0075f * (double)inaccuracy, entityItem.level().random.nextGaussian() * (double)0.0075f * (double)inaccuracy, entityItem.level().random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        entityItem.setDeltaMovement(vec3d);
        float f = Mth.sqrt((float)((float)(vec3d.x * vec3d.x + vec3d.z * vec3d.z)));
        entityItem.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
        entityItem.setXRot((float)(Mth.atan2((double)vec3d.y, (double)f) * 57.2957763671875));
        entityItem.yRotO = entityItem.getYRot();
        entityItem.xRotO = entityItem.getXRot();
    }
}

